package cn.qg.holmes.task;

import cn.qg.holmes.service.effect.DatabaseSyncService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 数据库同步定时任务
 */
@Slf4j
@Component
public class DbSyncTask {

    @Autowired
    DatabaseSyncService databaseSyncService;

    @Value("${dbsync.mysql.ip}")
    private String ip;

    @Value("${dbsync.mysql.port}")
    private String port;

    @Value("${dbsync.mysql.username}")
    private String username;

    @Value("${dbsync.mysql.password}")
    private String password;

//    @Scheduled(cron = "0 0 24 * * ?")
    @Scheduled(cron = "0 55 15 * * ?")
    public void getDbInfoFromSourceJob() {
        List<String> dbList = databaseSyncService.getDatabaseList(ip, port, username, password);
        for (String dbName: dbList) {
            databaseSyncService.getDbInfoFromSource(ip, port, username, password, dbName);
        }
    }
}
