package cn.qg.holmes.service.quality.impl;

import cn.qg.holmes.entity.quality.DingRobot;
import cn.qg.holmes.entity.quality.JiraBugPool;
import cn.qg.holmes.mapper.quality.DingRobotMapper;
import cn.qg.holmes.service.quality.DingRobotService;
import cn.qg.holmes.service.quality.JiraBugPoolService;
import cn.qg.holmes.utils.DingdingUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jayway.jsonpath.JsonPath;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@Slf4j
public class DingRobotServiceImpl extends ServiceImpl<DingRobotMapper, DingRobot> implements DingRobotService {

    @Autowired
    DingRobotMapper dingRobotMapper;

    @Autowired
    JiraBugPoolService jiraBugPoolService;

    @Override
    public Boolean sendMsgToDing(String jiraData) {
        log.info("收到jira bug提交：{}", jiraData);
        String webhookEvent = JsonPath.read(jiraData, "$.webhookEvent");
        if (StringUtils.equals(webhookEvent, "jira:issue_created")) {
            String creator = JsonPath.read(jiraData, "$.issue.fields.creator.displayName");
            String assignee = "";
            if (JsonPath.read(jiraData, "$.issue.fields.assignee") == null) {
                assignee = "未分配";
            } else {
                assignee = JsonPath.read(jiraData, "$.issue.fields.assignee.displayName");
            }
            String key = JsonPath.read(jiraData, "$.issue.key");
            String summary = JsonPath.read(jiraData, "$.issue.fields.summary");
            String priority = JsonPath.read(jiraData, "$.issue.fields.priority.name");
            String module = JsonPath.read(jiraData, "$.issue.fields.components[0].name");
            String robotUrl = null;
            Integer dingRobotId = null;
            Integer status = null;
            List<DingRobot> dingRobots = dingRobotMapper.selectList(null);
            for (DingRobot dingRobot : dingRobots) {
                String projectName = "【" + dingRobot.getProjectName() + "】";
                if (summary.contains(projectName)) {
                    robotUrl = dingRobot.getDingUrl();
                    dingRobotId = dingRobot.getId();
                    status = dingRobot.getStatus();
                    break;
                }
            }
            // 只有创建了dingRobot的项目的BUG才会被放到BUG池子里
            if (robotUrl != null && dingRobotId != null) {
                // 首次提交的BUG放入bug池子
                JiraBugPool jiraBugPool = new JiraBugPool();
                jiraBugPool.setKey(key);
                jiraBugPool.setSummary(summary);
                jiraBugPool.setPriority(priority);
                jiraBugPool.setReporter(creator);
                jiraBugPool.setAssignee(assignee);
                jiraBugPool.setUrl("http://jira2.quantgroup.cn/browse/" + key);
                jiraBugPool.setDingUrl(robotUrl);
                jiraBugPool.setDingRobotId(dingRobotId);
                jiraBugPoolService.save(jiraBugPool);
            }
            // 只有项目是进行中才会发送通知
            if (robotUrl != null && status == 1) {
                String markdownMsg = DingdingUtils.buildBugCommitMarkdownMsg(key, summary, creator, assignee, priority, module);
                return DingdingUtils.sendToDingding(markdownMsg, robotUrl);
            }
        }
        return false;
    }
}
