package cn.qg.holmes.controller.gitlab;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.gitlab.Pipeline;
import cn.qg.holmes.service.gitlab.PipelineService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.management.Query;
import javax.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.util.List;

@Slf4j
@RestController
@CrossOrigin
@RequestMapping("/pipline")
public class PipelineController {

    @Autowired
    PipelineService pipelineService;

    @PostMapping("/webhook")
    public void piplineWebhook(HttpServletRequest request) {
        StringBuilder piplineData = new StringBuilder();
        try {
            BufferedReader br = request.getReader();
            String str = "";
            while((str = br.readLine()) != null){
                piplineData.append(str);
            }
            br.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        log.info("收到gitlab推送来的数据：{}", piplineData);
        pipelineService.buildPipelineJob(String.valueOf(piplineData));
    }

    @PostMapping("/add")
    public JsonResult addPipeline(@RequestBody List<Pipeline> pipelineList) {
        return JsonResult.buildSuccessResult(pipelineService.saveBatch(pipelineList));
    }

    @PostMapping("/modify")
    public JsonResult modifyPipeline(@RequestBody List<Pipeline> pipelineList) {
        try {
            for (Pipeline pipeline: pipelineList) {
                if (pipelineService.getById(pipeline.getId()) == null) {
                    pipelineService.save(pipeline);
                } else {
                    pipelineService.updateById(pipeline);
                }
            }
            return JsonResult.buildSuccessResult(true);
        } catch (Exception e) {
            e.printStackTrace();
            return JsonResult.buildSuccessResult(false);
        }
    }
}
