package cn.qg.holmes.controller.auto;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.auto.Scene;
import cn.qg.holmes.service.auto.AutoProjectService;
import cn.qg.holmes.service.auto.SceneService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

/**
 * 场景相关接口
 * @author libo
 */
@CrossOrigin
@RestController
@RequestMapping("/auto/scene")
public class SceneController {

    @Autowired
    SceneService sceneService;

    @Autowired
    AutoProjectService autoProjectService;

    /**
     * 获取场景列表
     * @param pageNum 第几页
     * @param pageSize 每页多少个
     * @return
     */
    @GetMapping("/list")
    public JsonResult getSceneList(Integer projectId,
                                   @RequestParam(defaultValue = "1") Integer pageNum,
                                   @RequestParam(defaultValue = "10") Integer pageSize) {
        IPage<Scene> page = new Page<>(pageNum, pageSize);
        IPage<Scene> sceneIPage;
        if (projectId == null) {
            sceneIPage = sceneService.page(page);
        } else {
            QueryWrapper<Scene> sceneQueryWrapper = new QueryWrapper<>();
            sceneQueryWrapper.eq("project_id", projectId);
            sceneIPage = sceneService.page(page, sceneQueryWrapper);
        }
        Map<String, Object> map = new HashMap<>();
        map.put("list", sceneIPage.getRecords());
        map.put("total", sceneIPage.getTotal());
        return JsonResult.buildSuccessResult(map);
    }

    /**
     * 新增场景
     * @param scene 场景实体
     * @return
     */
    @PostMapping("/add")
    public JsonResult addScene(@RequestBody Scene scene) {
        if (scene.getProjectId() == null) {
            return JsonResult.buildErrorStateResult("项目不允许为空！", false);
        }
        if (scene.getName() == null) {
            JsonResult.buildErrorStateResult("场景名不允许为空！", false);
        }
        if (autoProjectService.getById(scene.getProjectId()) == null) {
            return JsonResult.buildErrorStateResult("项目不存在！", false);
        }
        return JsonResult.buildSuccessResult(sceneService.save(scene));
    }

    /**
     * 修改场景
     * @param scene 场景实体
     * @return
     */
    @PostMapping("/modify")
    public JsonResult modifyScene(@RequestBody Scene scene) {
        if (scene.getId() == null) {
            return JsonResult.buildErrorStateResult("场景id不能为空！", false);
        }
        if (autoProjectService.getById(scene.getProjectId()) == null) {
            return JsonResult.buildErrorStateResult("项目不存在！", false);
        }
        return JsonResult.buildSuccessResult(sceneService.updateById(scene));
    }

    /**
     * 删除场景
     * @param sceneId 场景id
     * @return
     */
    @GetMapping("/delete")
    public JsonResult deleteScene(Integer sceneId) {
        if (sceneService.getById(sceneId) == null) {
            return JsonResult.buildErrorStateResult("场景不存在！", false);
        }
        return JsonResult.buildSuccessResult(sceneService.removeById(sceneId));
    }
}
