package cn.qg.holmes.controller.auto;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.auto.Scene;
import cn.qg.holmes.entity.auto.SceneTestcase;
import cn.qg.holmes.entity.auto.SceneTestcaseUpdateVo;
import cn.qg.holmes.service.auto.AutoModuleService;
import cn.qg.holmes.service.auto.InterfaceService;
import cn.qg.holmes.service.auto.SceneService;
import cn.qg.holmes.service.auto.SceneTestcaseService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Slf4j
@CrossOrigin
@RestController
@RequestMapping("/auto/sceneTestcase")
public class SceneTestcaseController {

    @Autowired
    SceneService sceneService;

    @Autowired
    SceneTestcaseService sceneTestcaseService;

    @Autowired
    InterfaceService interfaceService;

    @Autowired
    AutoModuleService autoModuleService;

    /**
     * 获取场景用例列表
     * @param sceneId 场景id
     * @return
     */
    @GetMapping("/list")
    public JsonResult getSceneTestcaseListBySceneId(@RequestParam Integer sceneId) {
        if (sceneId == null) {
            return JsonResult.buildErrorStateResult("请传入场景id", false);
        }
        List<SceneTestcase> sceneTestcaseList = sceneTestcaseService.getSceneTestcaseListBySceneId(sceneId);
        return JsonResult.buildSuccessResult(sceneTestcaseList);
    }

    /**
     * 新增场景用例
     * @param sceneTestcaseList 场景用例列表
     * @return
     */
    @PostMapping("/add")
    public JsonResult addSceneTestcase(@RequestBody List<SceneTestcase> sceneTestcaseList) {
        // 首先查询表里是否已有相应的数据
        for (SceneTestcase sceneTestcase: sceneTestcaseList) {
            if (sceneTestcase.getSceneId() == null) {
                return JsonResult.buildErrorStateResult("场景id不能为空！", false);
            }
            if (sceneTestcase.getSequence() == null) {
                return JsonResult.buildErrorStateResult("用例顺序不能为空！", false);
            }
            if (sceneTestcase.getInterfaceId() == null) {
                return JsonResult.buildErrorStateResult("接口id不能为空！", false);
            }
            QueryWrapper<SceneTestcase> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("scene_id", sceneTestcase.getSceneId());
            queryWrapper.eq("sequence", sceneTestcase.getSequence());
            if (sceneTestcaseService.getOne(queryWrapper) != null) {
                return JsonResult.buildErrorStateResult("场景用例已存在！", false);
            }
        }
        for (SceneTestcase sceneTestcase: sceneTestcaseList) {
            sceneTestcaseService.save(sceneTestcase);
        }
        return JsonResult.buildSuccessResult(true);
    }

    /**
     * 批量修改场景用例列表
     * @param sceneTestcaseList 场景用例列表
     * @return
     */
    @PostMapping("/modify")
    public JsonResult modifySceneTestcase(@RequestBody List<SceneTestcase> sceneTestcaseList) {
        return JsonResult.buildSuccessResult(sceneTestcaseService.updateBatchById(sceneTestcaseList));
    }

    /**
     * 新增或批量修改场景用例列表
     * @param sceneTestcaseUpdateVo 场景用例列表
     * @return
     */
    @PostMapping("/saveOrUpdate")
    public JsonResult saveOrUpdateSceneTestcaseList(@RequestBody SceneTestcaseUpdateVo sceneTestcaseUpdateVo) {
        List<SceneTestcase> sceneTestcaseList = sceneTestcaseUpdateVo.getSceneTestcaseList();
        Integer sceneId = sceneTestcaseUpdateVo.getSceneId();
        String globalParameters = sceneTestcaseUpdateVo.getGlobalParameters();
        Scene scene = sceneService.getById(sceneId);
        scene.setGlobalParameters(globalParameters);
        sceneService.saveOrUpdate(scene);
        log.info("开始批量修改场景id为 {} 的场景用例：\n {}", sceneId, sceneTestcaseList);
        List<SceneTestcase> sceneTestcaseListInDB = sceneTestcaseService.getSceneTestcaseListBySceneId(sceneId);
        log.info("数据库中的场景用例为：{}", sceneTestcaseListInDB);
        if (sceneTestcaseListInDB.size() > 0) {
            for (SceneTestcase sceneTestcaseInDB: sceneTestcaseListInDB) {
                Integer DBId = sceneTestcaseInDB.getId();
                boolean flag = false;
                for (SceneTestcase sceneTestcase: sceneTestcaseList) {
                    // 过滤掉新增的
                    if (sceneTestcase.getId() != null) {
                        if (sceneTestcase.getId().equals(DBId)) {
                            flag = true;
                        }
                    }
                }
                if (!flag) {
                    log.info("{}不在传入的list中，删除该条数据！", sceneTestcaseInDB);
                    sceneTestcaseService.removeById(sceneTestcaseInDB.getId());
                }
            }
        }
        if (sceneTestcaseList.size() > 0) {
            return JsonResult.buildSuccessResult(sceneTestcaseService.saveOrUpdateBatch(sceneTestcaseList));
        }
        return JsonResult.buildSuccessResult(true);
    }

    /**
     * 删除单个场景用例
     * @param sceneTestcaseId 单个场景用例id
     * @return
     */
    @GetMapping("/delete")
    public JsonResult deleteSceneTestcase(@RequestParam Integer sceneTestcaseId) {
        if (sceneTestcaseService.getById(sceneTestcaseId) == null) {
            return JsonResult.buildErrorStateResult("场景用例不存在！", false);
        }
        return JsonResult.buildSuccessResult(sceneTestcaseService.removeById(sceneTestcaseId));
    }
}
