package cn.qg.holmes.controller.jira;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.jira.SendScheduleVo;
import cn.qg.holmes.service.jira.JiraIssueService;
import cn.qg.holmes.utils.DingdingUtils;
import com.atlassian.jira.rest.client.api.domain.Issue;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

@Slf4j
@CrossOrigin
@RestController
@RequestMapping("/jira")
public class JiraController {

    @Autowired
    JiraIssueService jiraIssueService;

    @Value("${task.debug}")
    private String taskDebug;

    @GetMapping("/report/project")
    public void sendReportToDingdingGroup(String project, String webhook) throws Exception {
        Iterable<Issue> issues = jiraIssueService.getUnsolvedIssueListByProject(project);
        String markdownMsg = DingdingUtils.buildMarkdownMsgForUnsolvedIssueList(issues);
        DingdingUtils.sendToDingding(markdownMsg, webhook);
    }

    /**
     * 发送测试进度
     * @return
     * @throws Exception
     */
    @PostMapping("/send/schedule")
    public JsonResult sendTestReport(@RequestBody SendScheduleVo sendScheduleVo) throws Exception {
        String JQL = "project = " + sendScheduleVo.getJiraProjectKey() + " AND resolution = Unresolved AND text ~ \"" + sendScheduleVo.getTestProjectName() +  "\" ORDER BY priority DESC, updated DESC";
        Iterable<Issue> issues = jiraIssueService.getIssueListByJQL(JQL);
        String markdownMsg = DingdingUtils.buildTestScheduleMarkdownMsg(issues, sendScheduleVo.getProgress(), sendScheduleVo.getRisk());
        return JsonResult.buildSuccessResult(DingdingUtils.sendToDingding(markdownMsg, sendScheduleVo.getWebhook()));
    }

    @GetMapping("/test")
    public void test() {
        if (taskDebug.equals("true")) {
            log.info("true");
        } else {
            log.info("false");
        }
    }
}
