package cn.qg.holmes.controller.monitor;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.monitor.SqlMonitorDataSource;
import cn.qg.holmes.service.monitor.SqlMonitorDataSourceService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

/**
 * 监控数据源相关接口
 */
@CrossOrigin
@RestController
@RequestMapping("/monitor/ds")
public class SqlMonitorDataSourceController {

    @Autowired
    SqlMonitorDataSourceService sqlMonitorDataSourceService;

    /**
     * 获取监控数据源列表，带分页和筛选
     * @param pageNum
     * @param pageSize
     * @param dsName
     * @return
     */
    @GetMapping("/listWithPaging")
    public JsonResult getMonitorDataSourceListWithPaging(@RequestParam(defaultValue = "1") Integer pageNum,
                                               @RequestParam(defaultValue = "10") Integer pageSize,
                                               String dsName) {
        IPage<SqlMonitorDataSource> IPageParam = new Page<>(pageNum, pageSize);
        QueryWrapper<SqlMonitorDataSource> queryWrapper = new QueryWrapper<>();
        if (!StringUtils.isEmpty(dsName)) {
            queryWrapper.eq("name", dsName);
        }
        IPage<SqlMonitorDataSource> IPageResult = sqlMonitorDataSourceService.page(IPageParam);
        Map<String, Object> dsResult = new HashMap<>();
        dsResult.put("total", IPageResult.getTotal());
        dsResult.put("list", IPageResult.getRecords());
        return JsonResult.buildSuccessResult(dsResult);
    }

    /**
     * 获取监控数据源接口，不带分页和筛选
     * @return
     */
    @GetMapping("/list")
    public JsonResult getMonitorDataSourceList() {
        return JsonResult.buildSuccessResult(sqlMonitorDataSourceService.list());
    }

    /**
     * 添加监控数据源
     * @param sqlMonitorDataSource
     * @return
     */
    @PostMapping("/add")
    public JsonResult addMonitorDataSource(@RequestBody SqlMonitorDataSource sqlMonitorDataSource) {
        return JsonResult.buildSuccessResult(sqlMonitorDataSourceService.saveOrUpdate(sqlMonitorDataSource));
    }

    /**
     * 更新监控数据源
     * @param sqlMonitorDataSource
     * @return
     */
    @PostMapping("/update")
    public JsonResult updateMonitorDataSource(@RequestBody SqlMonitorDataSource sqlMonitorDataSource) {
        Integer dsId = sqlMonitorDataSource.getId();
        if (dsId == null) {
            return JsonResult.buildErrorStateResult("数据源不存在！", null);
        }
        if (sqlMonitorDataSourceService.getById(dsId) == null) {
            return JsonResult.buildErrorStateResult("数据源不存在", null);
        }
        return JsonResult.buildSuccessResult(sqlMonitorDataSourceService.saveOrUpdate(sqlMonitorDataSource));
    }

    /**
     * 删除监控数据源
     * @param sqlMonitorDataSource
     * @return
     */
    @PostMapping("/delete")
    public JsonResult deleteMonitorDataSource(@RequestBody SqlMonitorDataSource sqlMonitorDataSource) {
        Integer dsId = sqlMonitorDataSource.getId();
        if (dsId == null) {
            return JsonResult.buildErrorStateResult("数据源不存在！", null);
        }
        if (sqlMonitorDataSourceService.getById(dsId) == null) {
            return JsonResult.buildErrorStateResult("数据源不存在", null);
        }
        return JsonResult.buildSuccessResult(sqlMonitorDataSourceService.getById(dsId));
    }
}
