package cn.qg.holmes.entity.effect;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.Date;

/**
 * 造数据文档模块类
 */
@TableName(value = "build_data")
@Data
public class BuildData {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 模块名称
     */
    @TableField(value = "name")
    @NotBlank(message = "模块名称不能为空")
    private String name;

    /**
     * 模块颜色
     */
    @TableField(value = "color")
    @NotBlank(message = "模块颜色不能为空")
    private String color;

    /**
     * 更新时间
     */
    @TableField(value = "update_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
}
