package cn.qg.holmes.controller.login;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.service.ldap.LoginService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
public class LoginController {

    @Autowired
    LoginService loginService;

    @PostMapping("/login")
    public JsonResult login(String username, String password) {
        return JsonResult.buildSuccessResult(loginService.login(username, password));
    }
}
