package cn.qg.holmes.entity.mock.keystone.jdbuy;

import lombok.Data;

import java.util.List;

/**
 * 9.2 申请售后
 */
@Data
public class AfsApplyRequest {

    private String token;

    private ApplyParam param;

    @Data
    public static class ApplyParam{

        private String orderId;  //京东子订单号

        private String thirdApplyId; //申请批次号，同一子订单下不可重复（长度最大20字符）

        private AfsCustomerInfo customerInfo; //用户信息

        private AfsPickupWareInfo pickwareInfo; //取件信息，即原商品如何返回京东或者卖家

        private AfsReturnWareInfo returnWareInfo; //返件信息，商品如何返回客户手中。当售后类型为换货、维修时，表示商品如何返回客户手中；当售后类型为退货时，表示退货失败商品返回客户手中的地址。

        private List<AfsApplyInfoItem> afsApplyInfoItemList; //申请信息集合。一个SKU只能有一个条目，一个SKU不能有两个或两个以上条目。

    }

    @Data
    public static class AfsCustomerInfo{

        private String customerName; //用户名

        private String customerContactName; //联系人

        private String customerTel; //联系电话，联系电话与手机号不能同时为空

        private String customerMobilePhone; //手机号，联系电话与手机号不能同时为空
    }

    @Data
    public static class AfsPickupWareInfo{

        private Integer pickwareType;  //取件方式。4上门取件7客户送货， 40客户发货。
        private Integer pickWareProvince;  //取件省
        private Integer pickWareCity;  //取件市
        private Integer pickWareCounty;  //取件县
        private Integer pickWareVillage;  //取件乡镇
        private String pickWareAddress;  //取件街道地址
    }

    @Data
    public static class AfsReturnWareInfo{
        private Integer returnWareType;  //返件方式。10自营配送，20第三方配送
        private Integer returnWareProvince;  //返件省
        private Integer returnWareCity;  //返件市
        private Integer returnWareCountry;  //返件县
        private Integer returnWareVillage;  //返件乡镇
        private String returnWareAddress;  //返件街道地址
    }

    @Data
    public static class AfsApplyInfoItem{
        private Integer customerExpect;  //客户期望售后类型。10退货，20换货，30维修
        private WareDescInfo wareDescInfo;  //商品描述信息
        private WareDetailInfo wareDetailInfo;  //商品明细
    }

    @Data
    public static class WareDescInfo{
        private Boolean isNeedDetectionReport;  //是否需要检测报告
        private Boolean lossPreventionTagFlag;  //是否有防损吊牌。
        private Boolean isHasPackage;  //是否有包装
        private Integer packageDesc;  //包装描述：0 无包装  10 包装完整  20 包装破损
        private String questionDesc;  //问题描述文字
        private String questionPic;   //问题描述图片链接。多个图片以“；”分隔
    }

    @Data
    public static class WareDetailInfo{
        private Long wareId;  //商品编号
        private Long mainWareId;  //主商品编号
        private String wareName;  //商品名称
        private Integer wareNum;  //商品申请数量
        private Integer wareType = 10;	//商品类型。10主商品，20赠品。
    }
}
