package cn.qg.holmes.encrypt;

import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.*;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.UUID;

/**
 * Created by Baiye on 25/01/2019.
 *
 * @author Baiye
 */
@SuppressWarnings("ALL")
public class LanzhouBankEncrypt {
    private static Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    /**
     * 使用指定的字符串生成秘钥
     *
     * @param password
     * @throws NoSuchAlgorithmException
     */
    private static String getRandomKey(String password) throws NoSuchAlgorithmException {
        //生成秘钥
        String s = "";
        KeyGenerator kg = KeyGenerator.getInstance("AES");
        // kg.init(128);//要生成多少位，只需要修改这里即可128, 192或256
        //SecureRandom是生成安全随机数序列，password.getBytes()是种子，只要种子相同，序列就一样，所以生成的秘钥就一样。
        kg.init(128, new SecureRandom(password.getBytes()));
        SecretKey sk = kg.generateKey();
        byte[] b = sk.getEncoded();
        s = byteToHexString(b);
        return s;
    }

    /**
     * 使用指定的字符串生成秘钥
     *
     * @throws NoSuchAlgorithmException
     */
    private static String getRandomKey() throws NoSuchAlgorithmException {
        return getRandomKey(UUID.randomUUID().toString());
    }

    /**
     * 十六进制string转二进制byte[]
     */
    private static byte[] hexStringToByte(String s) throws DecoderException {
        return Hex.decodeHex(s);
    }

    /**
     * 二进制byte[]转十六进制string
     */
    private static String byteToHexString(byte[] bytes) {
        return Hex.encodeHexString(bytes);
    }

    private static String rsapubKeyEnc(String content, String pubKey) throws IOException {
        InputStream is = null;
        try {
            KeyFactory keyf = KeyFactory.getInstance("RSA");
            //获取公钥
            is = new ByteArrayInputStream(pubKey.getBytes("utf-8"));
            byte[] pubbytes = new byte[new Long(pubKey.length()).intValue()];
            is.read(pubbytes);
            X509EncodedKeySpec pubX509 = new X509EncodedKeySpec(Base64.decodeBase64(pubbytes));
            PublicKey pkey = keyf.generatePublic(pubX509);

            //公钥加密
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(Cipher.ENCRYPT_MODE, pkey);
            byte[] cipherText = cipher.doFinal(content.getBytes());
            // 将加密结果转换为Base64编码结果；便于internet传送
            return Base64.encodeBase64String(cipherText);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        } finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private static byte[] aesEncrypt(byte[] key, byte[] src) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(Cipher.ENCRYPT_MODE, skeySpec);
        return cipher.doFinal(src);
    }

    private static byte[] aesDecrypt(byte[] key, byte[] encrypted) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(Cipher.DECRYPT_MODE, skeySpec);
        return cipher.doFinal(encrypted);
    }

    /**
     * RSA私钥解密
     *
     * @param ciphertext 经BASE84编码过的待解密密文
     * @param privKey    RSA私钥
     * @return utf-8编码的明文
     */
    private static String rsaprivKeyDec(String ciphertext, String privKey) {
        try {
            KeyFactory keyf = KeyFactory.getInstance("RSA");
            //        获取私钥
            InputStream key = new ByteArrayInputStream(privKey.getBytes("utf-8"));
            byte[] pribytes = new byte[new Long(privKey.length()).intValue()];
            key.read(pribytes);
            byte[] buffer = Base64.decodeBase64(pribytes);
            PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(buffer);
            PrivateKey prikey = keyf.generatePrivate(priPKCS8);

            //私钥解密
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(Cipher.DECRYPT_MODE, prikey);
            byte[] text = Base64.decodeBase64(ciphertext);
            byte[] content = cipher.doFinal(text);
            return new String(content, "UTF-8");
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    /**
     * 易贷云申请报文加密
     *
     * @param requestMessage 申请信息报文
     * @param publicKey      加密私钥
     * @return String[] 返回数组，数组下表0为加密信息 数组下表1为加密密钥
     * @throws Exception
     */
    public static String[] encrypt(byte[] requestMessage, String publicKey) {
        try {
            String[] byteReturn = new String[2];
            //获得随机密钥信息
            String randomKey = getRandomKey();
            byte[] encodeMessageByte = aesEncrypt(hexStringToByte(randomKey), requestMessage);

            String eMessage = byteToHexString(encodeMessageByte);
            String signature = rsapubKeyEnc(randomKey, publicKey);
            byteReturn[0] = eMessage;
            byteReturn[1] = signature;
            return byteReturn;
        } catch (Exception e) {
            throw new RuntimeException("加密异常", e);
        }
    }

    /**
     * 易贷云申请报文解密
     *
     * @param message   申请信息
     * @param signature 密钥
     * @return String 返回解密的信息明文
     * @throws Exception
     */
    public static String decrypt(String message, String signature, String privateKey) {
        String dKey = rsaprivKeyDec(signature, privateKey);
        byte[] stringByte;
        try {
            stringByte = aesDecrypt(hexStringToByte(dKey), hexStringToByte(message));
        } catch (Exception e) {
            throw new RuntimeException("解密失败", e);
        }
        return new String(stringByte, DEFAULT_CHARSET);
    }

    /***
     * MD5加码 生成32位md5码
     */
    public static String MD5(String inStr) {
        return DigestUtils.md5Hex(inStr);
    }
}
