package cn.qg.holmes.controller.k8s;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.service.k8s.ImageService;
import cn.qg.holmes.service.k8s.TkeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@CrossOrigin
@RestController
@RequestMapping("/k8s")
public class K8sController {

    @Autowired
    TkeService tkeService;

    @Autowired
    ImageService imageService;

    /**
     * 获取namespace列表
     * @return
     */
    @GetMapping("/namespace")
    public JsonResult getNamespaceList() {
        return JsonResult.buildSuccessResult(tkeService.getNamespaceList());
    }

    /**
     * 获取pod列表
     * @param namespace 环境
     * @return
     */
    @GetMapping("/pod/list")
    public JsonResult getServiceList(@RequestParam String namespace) {
        List<Map<String, Object>> podList = tkeService.getPodList(namespace);
        return JsonResult.buildSuccessResult(podList);
    }

    /**
     * 根据服务名称获取镜像列表
     * @param serviceName 服务名称
     * @return
     */
    @GetMapping("/image/list")
    public JsonResult getImageListByServiceName(@RequestParam String serviceName) {
        return JsonResult.buildSuccessResult(imageService.getImageListByService(serviceName));
    }

    @PostMapping("/pod/create")
    public JsonResult createPod() {
        return null;
    }

    /**
     * 重置pod
     * @param namespace 环境
     * @param podName podName
     * @return
     */
    @PostMapping("/pod/redeploy")
    public JsonResult resetPodByName(String namespace, String podName) {
        return JsonResult.buildSuccessResult(tkeService.resetPod(namespace, podName));
    }

    /**
     * 删除pod
     * @param namespace 环境
     * @param serviceName 服务名称
     * @return
     */
    @PostMapping("/pod/delete")
    public JsonResult deletePodByName(String namespace, String serviceName) {
        return JsonResult.buildSuccessResult(tkeService.deleteService(namespace, serviceName));
    }
}
