package cn.qg.holmes.utils;

import cn.qg.holmes.entity.ding.LinkEntity;
import com.jayway.jsonpath.JsonPath;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

@Slf4j
public class JiraWebhookUtils {

    public static void sendDingdingMsg(String jiraData) {
        String url = "https://oapi.dingtalk.com/robot/send?access_token=835663338d638e40daaf3ab358af741ef0680a826a962c91bedc53b149d85ee1";

        String webhookEvent = JsonPath.read(jiraData, "$.webhookEvent");
        if (StringUtils.equals(webhookEvent, "jira:issue_created")) {
            String creator = JsonPath.read(jiraData, "$.issue.fields.creator.displayName");
            String assignee = JsonPath.read(jiraData, "$.issue.fields.assignee.displayName");
            String key = JsonPath.read(jiraData, "$.issue.key");
            String summary = JsonPath.read(jiraData, "$.issue.fields.summary");
            LinkEntity linkEntity = new LinkEntity();
            linkEntity.setTitle(creator + " 创建故障 " + key + "给@" + assignee + ", 请注意查看！");
            linkEntity.setContent(summary);
            linkEntity.setMessageUrl("http://jira2.quantgroup.cn/browse/" + key);
            DingdingUtils.sendToDingding(linkEntity.getJSONObjectString(), url);
        }
    }
}
