package cn.qg.holmes.utils;

import org.gitlab.api.GitlabAPI;
import org.gitlab.api.models.GitlabBranch;
import org.gitlab.api.models.GitlabProject;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class GitlabService {

    private static final String URL = "http://git.quantgroup.cn/";

    private static final String TOKEN = "owKJZwenxNaypTAz4Zcd";

    private GitlabAPI gitlabAPI;

    public GitlabService() {
        try {
            gitlabAPI = GitlabAPI.connect(URL, TOKEN);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 获取所有的项目
     * @return
     */
    public List<Map<String, Object>> getProjectList() {
        List<GitlabProject> gitlabProjectList = gitlabAPI.getProjects();
        List<Map<String, Object>> projectMapList = new ArrayList<>();
        for (GitlabProject gitlabProject: gitlabProjectList) {
            Map<String, Object> map = new HashMap<>();
            map.put("id", gitlabProject.getId());
            map.put("name", gitlabProject.getName());
            projectMapList.add(map);
        }
        return projectMapList;
    }

    public List<String> getBranchesByProjectName(String projectName) {
        List<Map<String, Object>> projectList = getProjectList();
        Integer projectId = null;
        for (Map<String, Object> map: projectList) {
            if (map.get("name").toString().equals(projectName)) {
                projectId = (Integer) map.get("id");
            }
        }
        List<GitlabBranch> gitlabBranchList = gitlabAPI.getBranches(projectId);
        List<String> branches = new ArrayList<>();
        for (GitlabBranch gitlabBranch: gitlabBranchList) {
            branches.add(gitlabBranch.getName());
        }
        return branches;
    }

    public static void main(String[] args) {
        GitlabService gitlabService = new GitlabService();
        List<String> branches = gitlabService.getBranchesByProjectName("holmes");
        System.out.println(branches);
    }

}
