package cn.qg.holmes.controller.pipline;

import cn.qg.holmes.common.JsonResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.io.BufferedReader;

@Slf4j
@RestController
@CrossOrigin
@RequestMapping("/pipline")
public class PiplineController {

    @PostMapping("/webhook")
    public JsonResult piplineWebhook(HttpServletRequest request) {
        StringBuilder piplineData = new StringBuilder();
        try {
            BufferedReader br = request.getReader();
            String str = "";
            while((str = br.readLine()) != null){
                piplineData.append(str);
            }
            br.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        log.info("发送过来的pipline数据为：{}", piplineData);
        return JsonResult.buildSuccessResult(true);
    }
}
