package cn.qg.holmes.entity.monitor;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 监控定时任务配置实体类
 * @author libo
 */
@Data
@TableName(value = "monitor_task")
public class MonitorTask {

    @TableId(type = IdType.AUTO)
    private Integer id;

    /**
     * 定时任务执行类
     */
    @TableField(value = "`task_class`")
    @NotBlank(message = "定时任务执行类不能为空")
    private String taskClass;

    /**
     * 定时任务描述
     */
    @TableField(value = "`task_name`")
    @NotBlank(message = "定时任务名称不能为空")
    private String taskName;

    /**
     * 定时任务cron表达式
     */
    @TableField(value = "`task_cron`")
    private String taskCron;

    @TableField(value = "`sql`")
    private String sql;

    @TableField(value = "`ds_id`")
    @NotNull(message = "数据源id不能为空")
    private Integer dsId;

    @TableField(value = "`ding_url`")
    private String dingUrl;

    @TableField(value = "`ding_text`")
    private String dingText;

    /**
     * 状态，0-禁用，1-启用
     */
    @TableField(value = "`status`")
    private Integer status;

    /**
     * 服务名
     */
    @TableField(value = "`service_name`")
    private String serviceName;

    /**
     * 所有人
     */
    @TableField(value = "`owner`")
    private String owner;

    /**
     * 创建时间
     */
    @TableField(value = "`create_time`")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(value = "`update_time`")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @TableField(exist = false)
    private String dsName;
}
