package cn.qg.holmes.config;

import cn.qg.holmes.entity.monitor.MonitorTask;
import cn.qg.holmes.service.monitor.MonitorTaskService;
import cn.qg.holmes.utils.QuartzUtils;
import lombok.extern.slf4j.Slf4j;
import org.quartz.Scheduler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 项目启动时，初始化定时任务表里的任务
 */
@Slf4j
@Component
@Order(value = 5)
public class QuartzInitRunner implements ApplicationRunner {

    @Autowired
    MonitorTaskService monitorTaskService;

    @Autowired
    private Scheduler scheduler;

    @Override
    public void run(ApplicationArguments args) {
        List<MonitorTask> monitorTaskList = monitorTaskService.list();
        for (MonitorTask monitorTask: monitorTaskList) {
            if (monitorTask.getStatus() == 1) {
                QuartzUtils.createScheduleJob(scheduler, monitorTask);
            }
        }
    }
}
