package cn.qg.holmes.entity.mock;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

@Data
@TableName(value = "mock")
public class Mock {
    @TableId(type = IdType.AUTO)
    private Integer id;
    private String url;
    private String description;
    private String success;
    private String fail;
    /**
     * 0-返回失败，1-返回成功
     */
    private Integer flag;
    /**
     * 0-不加密，1-加密
     */
    private Integer encrypt;
    /**
     * 1-json，2-字符串
     */
    private Integer type;
    /**
     * 所属模块
     */
    private Integer module;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
}
