package cn.qg.holmes.service.auth.impl;

import cn.qg.holmes.entity.auth.User;
import cn.qg.holmes.entity.auth.UserInfoVo;
import cn.qg.holmes.mapper.auth.UserMapper;
import cn.qg.holmes.service.auth.RolePermissionService;
import cn.qg.holmes.service.auth.UserRoleService;
import cn.qg.holmes.service.auth.UserService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;

@Service
public class UserServiceImpl extends ServiceImpl<UserMapper, User> implements UserService {

    @Autowired
    UserMapper userMapper;

    @Autowired
    UserRoleService userRoleService;

    @Autowired
    RolePermissionService rolePermissionService;

    @Override
    public User getUserByUsername(String username) {
        QueryWrapper<User> userQueryWrapper = new QueryWrapper<>();
        userQueryWrapper.eq("username", username);
        return userMapper.selectOne(userQueryWrapper);
    }

    /**
     * 根据用户名获取用户信息
     * @param username
     * @return
     */
    @Override
    public UserInfoVo getUserInfoByUsername(String username) {
        UserInfoVo userInfoVo = new UserInfoVo();
        userInfoVo.setUsername(username);
        QueryWrapper<User> userQueryWrapper = new QueryWrapper<>();
        userQueryWrapper.eq("username", username);
        User user = userMapper.selectOne(userQueryWrapper);
        userInfoVo.setUserId(user.getId());
        List<Integer> roleIds = userRoleService.getRoleIdsByUserId(user.getId());
        userInfoVo.setRoleIds(roleIds);
        Set<String> permissionCodeSet = rolePermissionService.getPermissionSetForRoleIds(roleIds);
        userInfoVo.setPermissionCodeList(permissionCodeSet);
        Set<String> menuCodeSet = rolePermissionService.getMenuSetForRoleIds(roleIds);
        userInfoVo.setMenuList(menuCodeSet);
        return userInfoVo;
    }

    /**
     * 获取用户信息列表
     * @param pageNum
     * @param pageSize
     * @return
     */
    @Override
    public IPage<User> getUserInfoList(Integer pageNum, Integer pageSize) {
        IPage<User> page = new Page<>(pageNum, pageSize);
        return userMapper.getUserInfoList(page);
    }

}
