package cn.qg.holmes.controller.auto;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.service.auto.SceneTestcaseReportService;
import cn.qg.holmes.service.auto.TestcaseReportService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 报告相关接口
 *
 * @author libo
 */
@CrossOrigin
@RestController
@RequestMapping("/report")
public class TestReportController {

    @Autowired
    TestcaseReportService testcaseReportService;

    @Autowired
    SceneTestcaseReportService sceneTestcaseReportService;

    @GetMapping("/testcase/batch")
    public JsonResult getTestcaseReportByBatch(String batch) {
        return null;
    }

    @GetMapping("/scene/batch")
    public JsonResult getSceneReportByBatch() {
        return null;
    }

    @GetMapping("/testcase/list")
    public JsonResult getTestcaseReportListByNamespace(String namespace,
                                                       @RequestParam(defaultValue = "1") Integer pageNum,
                                                       @RequestParam(defaultValue = "10") Integer pageSize) {
        return JsonResult.buildSuccessResult(testcaseReportService.getTestcaseReportByNamespace(namespace, pageNum, pageSize));
    }

    @GetMapping("/scene/list")
    public JsonResult getSceneTestcaseReportListByNamespace(String namespace,
                                                            @RequestParam(defaultValue = "1") Integer pageNum,
                                                            @RequestParam(defaultValue = "10") Integer pageSize) {
        return JsonResult.buildSuccessResult(sceneTestcaseReportService.getSceneTestcaseReportListByNamespace(namespace, pageNum, pageSize));
    }
}
