package cn.qg.holmes.service.auto.impl;

import cn.qg.holmes.entity.auto.TestcaseReport;
import cn.qg.holmes.mapper.auto.TestcaseReportMapper;
import cn.qg.holmes.service.auto.TestcaseReportService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service
public class TestcaseReportServiceImpl extends ServiceImpl<TestcaseReportMapper, TestcaseReport> implements TestcaseReportService {

    @Autowired
    TestcaseReportMapper testcaseReportMapper;

    @Override
    public Map<String, Object> getTestcaseReportByNamespace(String namespace, Integer pageNum, Integer pageSize) {
        QueryWrapper<TestcaseReport> queryWrapper = new QueryWrapper<>();
        if (namespace != null && !namespace.isEmpty()) {
            queryWrapper.eq("namespace", namespace);
        }
        queryWrapper.orderByDesc("id");

        Page<TestcaseReport> page = new Page<>(pageNum, pageSize);
        IPage<TestcaseReport> iPage = testcaseReportMapper.selectPage(page, queryWrapper);

        Map<String, Object> map = new HashMap<>();
        map.put("total", iPage.getTotal());
        map.put("list", iPage.getRecords());
        return map;
    }
}
