package cn.qg.holmes.controller.auto;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.auto.Project;
import cn.qg.holmes.service.auto.ProjectService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

/**
 * 接口自动化项目相关controller
 * @author libo
 */
@CrossOrigin
@RestController
@RequestMapping("/auto/project")
public class ProjectController {

    @Autowired
    ProjectService projectService;

    /**
     * 获取项目列表
     * @param pageNum 第几页
     * @param pageSize 每页数量
     * @return
     */
    @GetMapping("/list")
    public JsonResult getAutoProjectList(@RequestParam Integer pageNum, @RequestParam Integer pageSize) {
        IPage<Project> projectIPage = new Page<>(pageNum, pageSize);
        IPage<Project> projectPageEntity = projectService.page(projectIPage);
        Map<String, Object> map = new HashMap<>();
        map.put("list", projectPageEntity.getRecords());
        map.put("total", projectPageEntity.getTotal());
        return JsonResult.buildSuccessResult(map);
    }

    /**
     * 新增项目
     * @param project 项目实体
     * @return
     */
    @PostMapping("/add")
    public JsonResult autoProjectAdd(@RequestBody Project project) {
        // 判断项目是否已存在
        QueryWrapper<Project> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("name", project.getName());
        if (projectService.getOne(queryWrapper) != null) {
            return JsonResult.buildErrorStateResult("该名称项目已存在!", false);
        } else {
            return JsonResult.buildSuccessResult(projectService.save(project));
        }
    }

    /**
     * 修改项目
     * @param project 项目实体
     * @return
     */
    @PostMapping("/modify")
    public JsonResult autoProjectModify(@RequestBody Project project) {
        if (projectService.getById(project.getId()) == null) {
            return JsonResult.buildErrorStateResult("项目不存在", false);
        } else {
            return JsonResult.buildSuccessResult(projectService.updateById(project));
        }
    }

    /**
     * 删除项目
     * @param projectId 项目id
     */
    @GetMapping("/delete")
    public JsonResult autoProjectDelete(@RequestParam Integer projectId) {
        if (projectService.getById(projectId) == null) {
            return JsonResult.buildErrorStateResult("该项目不存在！", false);
        } else {
            return JsonResult.buildSuccessResult(projectService.removeById(projectId));
        }
    }
}
