package cn.qg.holmes.service.auth.impl;

import cn.qg.holmes.entity.auth.UserRole;
import cn.qg.holmes.mapper.auth.UserRoleMapper;
import cn.qg.holmes.service.auth.UserRoleService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class UserRoleServiceImpl extends ServiceImpl<UserRoleMapper, UserRole> implements UserRoleService {

    @Autowired
    UserRoleMapper userRoleMapper;

    @Override
    public List<Integer> getRoleIdsByUserId(Integer userId) {
        QueryWrapper<UserRole> userRoleQueryWrapper = new QueryWrapper<>();
        userRoleQueryWrapper.eq("user_id", userId);
        List<UserRole> userRoleList = userRoleMapper.selectList(userRoleQueryWrapper);
        List<Integer> roleIds = new ArrayList<>();
        userRoleList.forEach(userRole -> {
            roleIds.add(userRole.getRoleId());
        });
        return roleIds;
    }
}
