package cn.qg.holmes.utils;

import org.apache.commons.lang3.time.FastDateFormat;

import java.text.ParseException;
import java.time.*;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;

/**
 * 日期格式化工具类
 */
public class DateUtils {

    public static Date getCurrentTime() {
        return new Date(System.currentTimeMillis());
    }

    public static String getCurrentDate(String pattern) {
        LocalDate now = LocalDate.now();
        return now.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String convertDate(Date date, String pattern) {
        return FastDateFormat
                .getInstance(pattern)
                .format(date);
    }

    public static Date convertStr(String date, String pattern) throws ParseException {
        return FastDateFormat
                .getInstance(pattern)
                .parse(date);
    }

    public static long betweenDays(Date dateBefore, Date dateAfter) {
        return Duration.between(toLocalDate(dateBefore).atStartOfDay(), toLocalDate(dateAfter).atStartOfDay())
                .toDays();
    }

    public static LocalDate toLocalDate(Date date) {
        return date.toInstant()
                .atZone(ZoneId.systemDefault())
                .toLocalDate();
    }

    public static String formatLocalTime(LocalTime localTime, String pattern) {
        return DateTimeFormatter.ofPattern(pattern).format(localTime);
    }

    public static String formatLocalDate(LocalDate localDate, String pattern) {
        return DateTimeFormatter.ofPattern(pattern).format(localDate);
    }

    // 获得某天最小时间 2020-02-17 00:00:00
    public static Date getStartOfDay(Date date) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
        LocalDateTime startOfDay = localDateTime.with(LocalTime.MIN);
        return Date.from(startOfDay.atZone(ZoneId.systemDefault()).toInstant());
    }

    // 获得某天最大时间 2020-02-19 23:59:59
    public static Date getEndOfDay(Date date) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
        LocalDateTime endOfDay = localDateTime.with(LocalTime.MAX);
        return Date.from(endOfDay.atZone(ZoneId.systemDefault()).toInstant());
    }

    // 获取指定日期的前几天
    public static Date getBeforeDay(Date date, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.DAY_OF_MONTH, day * -1);
        return calendar.getTime();
    }

    // 获取指定日期的后几天
    public static Date getAfterDay(Date date, int day) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(date.getTime());
        c.add(Calendar.DATE, day);
        return new Date(c.getTimeInMillis());
    }

}
