package cn.qg.holmes.config;

import cn.qg.holmes.entity.monitor.SqlMonitorTask;
import cn.qg.holmes.service.monitor.SqlMonitorTaskService;
import cn.qg.holmes.utils.QuartzUtils;
import lombok.extern.slf4j.Slf4j;
import org.quartz.Scheduler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 项目启动时，初始化定时任务表里的任务
 */
@Slf4j
@Component
@Order(value = 5)
public class QuartzInitRunner implements ApplicationRunner {

    @Autowired
    SqlMonitorTaskService sqlMonitorTaskService;

    @Autowired
    private Scheduler scheduler;

    @Override
    public void run(ApplicationArguments args) {
        List<SqlMonitorTask> sqlMonitorTaskList = sqlMonitorTaskService.list();
        for (SqlMonitorTask sqlMonitorTask : sqlMonitorTaskList) {
            if (sqlMonitorTask.getStatus() == 1) {
                QuartzUtils.createSqlScheduleJob(scheduler, sqlMonitorTask);
            }
        }
    }
}
