package cn.qg.holmes.entity.navigate;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * 导航详情
 * @author libo
 */
@Data
@TableName(value = "navigate_detail")
public class NavigateDetail {

    @TableId(type = IdType.AUTO)
    private Integer id;

    /**
     * 导航名称
     */
    private String name;

    /**
     * 导航地址
     */
    private String url;

    /**
     * 模块id
     */
    private Integer module;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @TableField(exist = false)
    private String moduleName;
}
