package cn.qg.holmes.service.auto.impl;

import cn.qg.holmes.entity.auto.AutoModule;
import cn.qg.holmes.entity.auto.Interface;
import cn.qg.holmes.entity.auto.SceneTestcase;
import cn.qg.holmes.entity.auto.SceneTestcaseReport;
import cn.qg.holmes.mapper.auto.SceneTestcaseMapper;
import cn.qg.holmes.service.auto.*;
import cn.qg.holmes.utils.HttpClientUtils;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @author libo
 * created at 2021-03-30
 */
@Service
@Slf4j
public class SceneTestcaseServiceImpl extends ServiceImpl<SceneTestcaseMapper, SceneTestcase> implements SceneTestcaseService {

    @Autowired
    SceneTestcaseMapper sceneTestcaseMapper;

    @Autowired
    TestcaseService testcaseService;

    @Autowired
    InterfaceService interfaceService;

    @Autowired
    AutoModuleService autoModuleService;

    @Autowired
    AutoUtilsService autoUtilsService;

    @Autowired
    SceneTestcaseReportService sceneTestcaseReportService;

    @Autowired
    SceneService sceneService;

    /**
     * 执行场景用例
     * @param namespace 环境
     * @param sceneId 场景id
     * @param batch 批次号
     * @return
     */
    @Override
    public String executeSceneTestcase(String namespace, Integer sceneId, String batch) {
        QueryWrapper<SceneTestcase> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("scene_id", sceneId);
        queryWrapper.orderByAsc("sequence");
        List<SceneTestcase> sceneTestcaseList =  sceneTestcaseMapper.selectList(queryWrapper);
        List<Map<String, Object>> resultList = new ArrayList<>();
        String globalParameters = sceneService.getById(sceneId).getGlobalParameters();
        // 全局变量Map
        Map<String, Object> globalMap = new HashMap<>();
        if (globalParameters != null) {
            globalMap.putAll(JSON.parseObject(globalParameters, Map.class));
        }
        for (SceneTestcase sceneTestcase: sceneTestcaseList) {
            String preAction = sceneTestcase.getPreAction();
            if (preAction != null && !preAction.isEmpty()) {
                Map<String, Object> preMap = autoUtilsService.handlePreCondition(namespace, preAction, globalMap);
                if (preMap != null) {
                    globalMap.putAll(preMap);
                }
            }
//            resultList.add(JSON.parseObject(sceneTestcaseExecution(namespace, sceneId, sceneTestcase.getInterfaceId(), sceneTestcase.getSequence(), uuid, batch), Map.class));
            Map<String, Object> tempMap = sceneTestcaseExecution(namespace, sceneId, sceneTestcase.getInterfaceId(), sceneTestcase.getSequence(), batch, globalMap);
            Map<String, Object> reportMap = (Map<String, Object>) tempMap.get("report");
            Map<String, Object> extractMap = (Map<String, Object>) tempMap.get("extract");
            resultList.add(reportMap);
            // 将解析出来的值放入全局变量Map
            globalMap.putAll(extractMap);
        }
        return JSON.toJSONString(resultList);
    }

    /**
     * 获取场景用例列表
     * @param sceneId 项目id
     * @return
     */
    @Override
    public List<SceneTestcase> getSceneTestcaseListBySceneId(Integer sceneId) {
        return sceneTestcaseMapper.getSceneTestcaseListBySceneId(sceneId);
    }

    public Map<String, Object> sceneTestcaseExecution(String namespace, Integer sceneId, Integer interfaceId, Integer sequence, String batch, Map<String, Object> globalMap) {
        QueryWrapper<SceneTestcase> queryWrapper = new QueryWrapper();
        queryWrapper.eq("scene_id", sceneId);
        queryWrapper.eq("interface_id", interfaceId);
        queryWrapper.eq("sequence", sequence);
        SceneTestcase sceneTestcase = sceneTestcaseMapper.selectOne(queryWrapper);
        Interface anInterface = interfaceService.getById(interfaceId);
        AutoModule autoModule = autoModuleService.getById(anInterface.getModuleId());
        String domain = autoModule.getDomain();
        String url = domain.replace("${NAMESPACE}", namespace) + anInterface.getUrl();
        log.info("开始执行接口：{}", url);
        String method = anInterface.getMethod().toUpperCase();
        String paramType = anInterface.getParamType();
        String interfaceName = anInterface.getName();
        String headers = sceneTestcase.getHeaders();
        String parameters = sceneTestcase.getParameters();
        String extract = sceneTestcase.getExtract();
        String validate = sceneTestcase.getValidate();
        Map<String, String> parameterMap = JSON.parseObject(parameters, Map.class);
        Map<String, String> headersMap = JSON.parseObject(headers, Map.class);
        if (headers != null && !headers.isEmpty()) {
//            headersMap = autoUtilsService.replaceVariables(headers, uuid);
            headersMap = autoUtilsService.replaceVariablesNew(namespace, headers, globalMap);
        }
        if (parameters != null && !parameters.isEmpty()) {
//            parameterMap = autoUtilsService.replaceVariables(parameters, uuid);
            parameterMap = autoUtilsService.replaceVariablesNew(namespace, parameters, globalMap);
        }
        // 创建断言列表
        List<Map> validateList = new ArrayList<>();
        if (validate != null && !validate.isEmpty()) {
            validateList = JSON.parseArray(validate, Map.class);
        }
        String response = "";
        Long startTime = System.currentTimeMillis();
        switch (method) {
            case "GET":
                response = HttpClientUtils.doGet(url, headersMap, parameterMap);
                break;
            case "POST":
                if (paramType.equals("json")) {
                    response = HttpClientUtils.doPostJson(url, headersMap, JSON.toJSONString(parameterMap));
                } else if (paramType.equals("form")) {
                    response = HttpClientUtils.doPost(url, headersMap, parameterMap);
                }
                break;
            default:
                log.info("暂不支持该请求方法：{}", method);
                break;
        }
        Long endTime = System.currentTimeMillis();
        Long elapsedTime = endTime - startTime;
        log.info("本次接口的响应为：{}", response);
        log.info("本次接口执行时间：{}", elapsedTime);
        // 进行断言
        boolean assertResult = true;
        if (!validateList.isEmpty()) {
            assertResult = autoUtilsService.assertResponse(response, validateList);
        }
        // 解析响应
        Map<String, Object> extractMap = new HashMap<>();
        if (extract != null && !extract.isEmpty()) {
//            autoUtilsService.extractResponse(response, extract, uuid);
            extractMap = autoUtilsService.extractResponseNew(response, extract);
        }
        Map<String, Object> reportMap = new HashMap<>();
        reportMap.put("url", url);
        reportMap.put("name", interfaceName);
        reportMap.put("headers", headersMap);
        reportMap.put("parameters", parameterMap);
        reportMap.put("assertResult", assertResult);
        reportMap.put("elapsedTime", elapsedTime);
        try {
            reportMap.put("response", JSON.parseObject(response, Map.class));
        } catch (Exception e) {
            reportMap.put("response", response);
        }

        // 插入测试报告
        SceneTestcaseReport sceneTestcaseReport = new SceneTestcaseReport();
        sceneTestcaseReport.setSceneId(sceneId);
        sceneTestcaseReport.setSceneTestcaseId(sceneTestcase.getId());
        sceneTestcaseReport.setSequence(sceneTestcase.getSequence());
        sceneTestcaseReport.setInterfaceUrl(anInterface.getUrl());
        sceneTestcaseReport.setInterfaceName(anInterface.getName());
        sceneTestcaseReport.setTestcaseName(sceneTestcase.getName());
        sceneTestcaseReport.setUrl(url);
        sceneTestcaseReport.setHeaders(JSON.toJSONString(headersMap));
        sceneTestcaseReport.setParameters(JSON.toJSONString(parameterMap));
        if (assertResult) {
            sceneTestcaseReport.setStatus("pass");
        } else {
            sceneTestcaseReport.setStatus("fail");
        }
        sceneTestcaseReport.setElapsedTime(elapsedTime);
        sceneTestcaseReport.setResponse(response);
        sceneTestcaseReport.setValidate(validate);
        sceneTestcaseReport.setBatch(batch);
        sceneTestcaseReport.setProjectId(sceneService.getById(sceneId).getProjectId());
        sceneTestcaseReport.setNamespace(namespace);
        log.info("保存测试报告：{}", sceneTestcaseReport);
        sceneTestcaseReportService.save(sceneTestcaseReport);
        Map<String, Object> resultMap = new HashMap<>();
        resultMap.put("report", reportMap);
        resultMap.put("extract", extractMap);
        return resultMap;
    }

}
