package cn.qg.holmes.interceptor;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InterceptorUtils {

    /**
     * 修改返回响应
     * @param response HttpServletResponse
     * @param result 返回的json或字符串
     */
    public static void constructResponse(HttpServletResponse response, String result) {
        PrintWriter writer = null;
        response.setCharacterEncoding("UTF-8");
//        response.setContentType("application/json; charset=utf-8");
        try {
            writer = response.getWriter();
            writer.print(result);
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    /**
     * 修改返回响应
     * @param response HttpServletResponse
     * @param result 返回的json或字符串
     * @param contentType content-type
     */
    public static void constructResponse(HttpServletResponse response, String result, String contentType) {
        PrintWriter writer = null;
        response.setCharacterEncoding("UTF-8");
        response.setContentType(contentType);
        try {
            writer = response.getWriter();
            writer.print(result);
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    /**
     * 将HttpServletRequest的parameterMap由Map<String, String[]>转换成Map<String, Object>
     * @param parameterMap request.getParameterMap()
     * @return
     */
    public static Map<String, Object> convertParameterMap(Map<String, String[]> parameterMap) {
        Map<String, Object> map = new HashMap<>();
        for (Map.Entry<String, String[]> entry: parameterMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue()[0];
            map.put(key, value);
        }
        return map;
    }

    /**
     * 解析从数据库获取的响应，赋对应的值
     * @param requestMap 请求Map
     * @param responseMap 响应Map
     * @return
     */
    public static Map<String, Object> disposeResponseMap(Map<String, Object> requestMap, Map<String, Object> responseMap) {
        for (Map.Entry<String, Object> entry: responseMap.entrySet()) {
            if (entry.getValue() instanceof List) {
                List<Map> list = (List) entry.getValue();
                for (Map<String, Object> map: list) {
                    for (Map.Entry<String, Object> entry2: map.entrySet()) {
                        String value2 = entry2.getValue().toString();
                        if (value2.startsWith("$request")) {
                            entry2.setValue(requestMap.get(value2.split("\\.")[1]));
                        }
                    }
                }
            } else if (entry.getValue() instanceof String) {
                String value = entry.getValue().toString();
                if (value.startsWith("$request")) {
                    entry.setValue(requestMap.get(value.split("\\.")[1]));
                }
                if (value.equals("true")) {
                    entry.setValue(true);
                }
                if (value.equals("false")) {
                    entry.setValue(false);
                }
            }
        }
        return responseMap;
    }
}
