package cn.qg.holmes.utils;

import com.alibaba.fastjson.JSON;
import com.jayway.jsonpath.JsonPath;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;

@Slf4j
public class JiraWebhookUtils {

    public static void sendDingdingMsg(String jiraData) {
        String url = "https://oapi.dingtalk.com/robot/send?access_token=835663338d638e40daaf3ab358af741ef0680a826a962c91bedc53b149d85ee1";

        String webhookEvent = JsonPath.read(jiraData, "$.webhookEvent");
        if (StringUtils.equals(webhookEvent, "jira:issue_created")) {
            String creator = JsonPath.read(jiraData, "$.issue.fields.creator.displayName");
            String assignee = JsonPath.read(jiraData, "$.issue.fields.assignee.displayName");
            String key = JsonPath.read(jiraData, "$.issue.key");
            String summary = JsonPath.read(jiraData, "$.issue.fields.summary");
            String priority = JsonPath.read(jiraData, "$.issue.fields.priority.name");
            String markdownMsg = DingdingUtils.buildMarkdownMsg(key, summary, creator, assignee, priority);
            DingdingUtils.sendToDingding(markdownMsg, url);
        }
    }

    public static void main(String[] args) {
        String url = "https://oapi.dingtalk.com/robot/send?access_token=835663338d638e40daaf3ab358af741ef0680a826a962c91bedc53b149d85ee1";
        Map<String, Object> markdown = new HashMap<>();
        Map<String, String> content = new HashMap<>();
        markdown.put("msgtype", "markdown");
        content.put("title", "黎博提交了BUG：CSXT-142");
        content.put("text", "## 黎博提交了BUG：CSXT-142" + "\n" + "### 概要：[【羊小咩v7.6.00】【iOS】【搜索】首页主搜索和专题页或者满减页等搜索逻辑问题]" + "(http://jira2.quantgroup.cn/browse/CSXT-143)"+ "\n" + "优先级：" + "P3一般" + "\n" + "经办人：" + "于巧玲");
        markdown.put("markdown", content);
        DingdingUtils.sendToDingding(JSON.toJSONString(markdown), url);
    }
}
