package cn.qg.holmes.utils;

import org.apache.ibatis.jdbc.ScriptRunner;

import java.math.BigDecimal;
import java.sql.*;
import java.util.ArrayList;
import java.util.List;

public class SqlExecutionUtils {

    public static void executeSqlFileByMysql(String host,
                                             String port,
                                             String username,
                                             String password,
                                             String dbName) {
        String driver = "com.mysql.jdbc.Driver";
        String url = "jdbc:mysql://" + host + ":" + port + "/" + dbName + "?zeroDateTimeBehavior=convertToNull";

        Connection connection = null;
        List<String> columnNameList = new ArrayList<>();
        List<String> columnTypeList = new ArrayList<>();
        List<String> commentList = new ArrayList<>();

        String dbBackupInfo = "";

        try {
            Class.forName(driver);
            connection = DriverManager.getConnection(url, username, password);

            connection.setAutoCommit(false);

//            runner.runScript(new InputStreamReader(new FileInputStream(sqlFilePath), "utf-8"));
            // 获取创建数据库的语句
            DatabaseMetaData databaseMetaData = connection.getMetaData();
//            String dbSql = String.format("SHOW CREATE DATABASE %s", dbName);
//            PreparedStatement preparedStatement1 = connection.prepareStatement(dbSql);
//            ResultSet dResultSet = preparedStatement1.executeQuery();
//            while (dResultSet.next()) {
//                System.out.println(dResultSet.getString(2));
//            }
//            preparedStatement1.close();

//            String createDbSql = "CREATE DATABASE `kdsp` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci */";
//            PreparedStatement preparedStatement  = connection.prepareStatement(createDbSql);
//            preparedStatement.execute();
//            preparedStatement.close();

//            List<String> databaseList = new ArrayList<>();
//            String showDatabasesSql = "SHOW DATABASES";
//            PreparedStatement preparedStatement = connection.prepareStatement(showDatabasesSql);
//            ResultSet dbListResultSet = preparedStatement.executeQuery();
//            while (dbListResultSet.next()) {
//                databaseList.add(dbListResultSet.getString(1));
//                System.out.println(dbListResultSet.getString(1));
//            }

            // 获取所有表名
            ResultSet tableResultSet = databaseMetaData.getTables(null, null, null, new String[]{"TABLE"});
            while (tableResultSet.next()) {
                String tableName = tableResultSet.getString("TABLE_NAME");
                System.out.println("表名：" + tableName);

                // 获取所有建表语句
                String createTableSql = "";
                String sql = String.format("SHOW CREATE TABLE %s", tableName);
                PreparedStatement preparedStatement = connection.prepareStatement(sql);
                ResultSet pResultSet = preparedStatement.executeQuery();
                while (pResultSet.next()) {
//                    System.out.println(pResultSet.getString(2));
                    createTableSql = pResultSet.getString(2);
                }
                preparedStatement.close();

//                String querySql = String.format("SELECT * FROM %s", tableName);
//                PreparedStatement preparedStatement1 = connection.prepareStatement(querySql);
//                ResultSetMetaData resultSetMetaData = preparedStatement1.getMetaData();
//                int size = resultSetMetaData.getColumnCount();
//                for (int i = 0; i < size; i++) {
//                    columnNameList.add(resultSetMetaData.getColumnName(i + 1));
//                    columnTypeList.add(resultSetMetaData.getColumnTypeName(i + 1));
//                }

                // 获取行
//                ResultSet columnResultSet = databaseMetaData.getColumns(null, "%", tableName, "%");
//                while (columnResultSet.next()) {
//                    String columnName = columnResultSet.getString("COLUMN_NAME");
//                    // 数据类型
//                    String columnType = columnResultSet.getString("TYPE_NAME");
//                    // 字段长度
//                    int datasize = columnResultSet.getInt("COLUMN_SIZE");
//                    // 小数部分位数
//                    int digits = columnResultSet.getInt("DECIMAL_DIGITS");
//                    // 是否可为空 1代表可空 0代表不可为空
//                    int nullable = columnResultSet.getInt("NULLABLE");
//                    // 描述
//                    String remarks = columnResultSet.getString("REMARKS");
//                    columnNameList.add(columnName);
//                    columnTypeList.add(columnType);
//                    commentList.add(remarks);
////                    System.out.println(columnName + " " + columnType + " " + datasize + " " + digits + " " + nullable + " " + remarks);
//                }
//                System.out.println(columnNameList);
//                System.out.println(columnTypeList);
//                System.out.println(commentList);
//
//                String columnArrayStr = null;
//                for (String column : columnNameList) {
//                    if (null == columnArrayStr) {
//                        columnArrayStr = "`" + column + "`";
//                    } else {
//                        columnArrayStr = columnArrayStr + "," + "`" + column + "`";
//                    }
//                }
//
//                String selectSQL = String.format("select %s from %s", columnArrayStr, tableName);
//                System.out.println(selectSQL);
//                PreparedStatement selectPstmt = connection.prepareStatement(selectSQL);
//                ResultSet selResultSet = selectPstmt.executeQuery();
//                while (selResultSet.next()) {
//                    String rowValues = getRowValues(selResultSet, columnNameList.size(), columnTypeList);
//                    String insertSql = String.format("insert into %s (%s) values(%s);", tableName, columnArrayStr,
//                            rowValues);
////                    System.out.println(insertSql);
//                    insertSql = insertSql.replaceAll("\n", "<br/>");
//                    insertSql = insertSql + "\n";
//                    dbBackupInfo += insertSql;
//                }
//                columnNameList.clear();
//                columnTypeList.clear();
//                commentList.clear();
//                selectPstmt.close();
//            }
            }
            System.out.println(dbBackupInfo);
            connection.commit();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            close(connection);
        }
    }

    private static void close(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getRowValues(ResultSet rs, int size, List<String> columnTypeList) {
        try {
            String rowValues = null;
            for (int i = 1; i <= size; i++) {
                String columnValue = null;

                // 获取字段值
                columnValue = getValue(rs, i, columnTypeList.get(i - 1));
                // 如果是空值不添加单引号
                if (null != columnValue) {
                    columnValue = "'" + columnValue + "'";
                }
                // 拼接字段值
                if (null == rowValues) {
                    rowValues = columnValue;
                } else {
                    rowValues = rowValues + "," + columnValue;
                }
            }

            return rowValues;
        } catch (Exception e) {
            e.printStackTrace();
            System.out.println("获取表数据一行的所有值异常");
            return null;
        }
    }

    /**
     *
     * <p>
     * 根据类型获取字段值
     * </p>
     *
     * @return
     * @author  2018年9月6日 上午11:16:00
     */
    private static String getValue(ResultSet resultSet, Integer index, String columnType) {
        try {
            if ("int".equals(columnType) || "INT".equals(columnType)) {
                // 整数
                Object intValue = resultSet.getObject(index);

                if (null == intValue) {
                    return null;
                }
                return intValue + "";
            } else if ("bigint".equals(columnType) || "BIGINT".equals(columnType)) {

                // 长整形
                Object value = resultSet.getObject(index);
                if (null == value) {
                    return null;
                }
                return value + "";
            } else if ("smallint".equals(columnType) || "SMALLINT".equals(columnType)) {
                // 整数
                Object value = resultSet.getObject(index);
                if (null == value) {
                    return null;
                }
                return value + "";
            } else if ("tinyint".equals(columnType) || "TINYINT".equals(columnType)) {
                // 整数
                Object value = resultSet.getObject(index);
                if (null == value) {
                    return null;
                }
                return value + "";
            } else if ("mediumint".equals(columnType) || "MEDIUMINT".equals(columnType)) {
                // 长整形
                Object value = resultSet.getObject(index);
                if (null == value) {
                    return null;
                }
                return value + "";
            } else if ("integer".equals(columnType) || "INTEGER".equals(columnType)) {
                // 整数
                Object value = resultSet.getObject(index);
                if (null == value) {
                    return null;
                }
                return value + "";
            } else if ("float".equals(columnType) || "FLOAT".equals(columnType)) {

                // 浮点数
                Object value = resultSet.getObject(index);
                if (null == value) {
                    return null;
                }
                return value + "";
            } else if ("double".equals(columnType) || "DOUBLE".equals(columnType)) {
                // 浮点数
                Object value = resultSet.getObject(index);
                if (null == value) {
                    return null;
                }
                return value + "";
            } else if ("decimal".equals(columnType) || "DECIMAL".equals(columnType)) {
                // 浮点数-金额类型
                BigDecimal value = resultSet.getBigDecimal(index);
                if (null == value) {
                    return null;
                }
                return value.toString();
            } else if ("char".equals(columnType) || "CHAR".equals(columnType)) {
                // 字符串类型
                String value = resultSet.getString(index);
                return value;
            } else if ("varchar".equals(columnType) || "VARCHAR".equals(columnType)) {
                // 字符串类型
                String value = resultSet.getString(index);
                return value;
            } else if ("tinytext".equals(columnType) || "TINYTEXT".equals(columnType)) {
                // 字符串类型
                String value = resultSet.getString(index);
                return value;
            } else if ("text".equals(columnType) || "TEXT".equals(columnType)) {
                // 字符串类型
                String value = resultSet.getString(index);
                return value;
            } else if ("mediumtext".equals(columnType) || "MEDIUMTEXT".equals(columnType)) {
                // 字符串类型
                String value = resultSet.getString(index);
                return value;
            } else if ("longtext".equals(columnType) || "LONGTEXT".equals(columnType)) {
                // 字符串类型
                String value = resultSet.getString(index);
                return value;
            } else if ("year".equals(columnType) || "YEAR".equals(columnType)) {
                // 时间类型：范围 1901/2155 格式 YYYY
                String year = resultSet.getString(index);
                if (null == year) {
                    return null;
                }
                // 只需要年的字符即可，
                return year.substring(0, 4);
            } else if ("date".equals(columnType) || "DATE".equals(columnType)) {
                // 时间类型：范围 '1000-01-01'--'9999-12-31' 格式 YYYY-MM-DD
                return resultSet.getString(index);
            } else if ("time".equals(columnType) || "TIME".equals(columnType)) {
                // 时间类型：范围 '-838:59:59'到'838:59:59' 格式 HH:MM:SS
                return resultSet.getString(index);
            } else if ("datetime".equals(columnType) || "DATETIME".equals(columnType)) {
                // 时间类型：范围 '1000-01-01 00:00:00'--'9999-12-31 23:59:59' 格式 YYYY-MM-DD HH:MM:SS
                return resultSet.getString(index);
            } else if ("timestamp".equals(columnType) || "TIMESTAMP".equals(columnType)) {
                // 时间类型：范围 1970-01-01 00:00:00/2037 年某时 格式 YYYYMMDD HHMMSS 混合日期和时间值，时间戳
                return resultSet.getString(index);
            } else {
                return null;
            }
        } catch (Exception e) {
            e.printStackTrace();
            System.err.println("获取数据库类型值异常");
            return null;
        }
    }

    public static void main(String[] args) {
        executeSqlFileByMysql("172.30.5.35", "3308", "xyqb_query", "Uiwb@o^fR&nHOa5t", "vcc_talos");
//        executeSqlFileByMysql("172.17.5.24", "31024", "qa", "qatest", "kdsp");
    }
}
