package cn.qg.holmes.controller.effect;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.service.effect.DatabaseSyncService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@Slf4j
@CrossOrigin
@RestController
@RequestMapping("/dbsync")
public class DbSyncController {

    @Autowired
    DatabaseSyncService databaseSyncService;

    @Value("${dbsync.mysql.ip}")
    private String ip;

    @Value("${dbsync.mysql.port}")
    private String port;

    @Value("${dbsync.mysql.username}")
    private String username;

    @Value("${dbsync.mysql.password}")
    private String password;

    @GetMapping("/one")
    public JsonResult syncSingleTable(@RequestParam String namespace, @RequestParam String dbName, @RequestParam String tableName) {
        try {
            long startTime = System.currentTimeMillis();
            Map<String, String> map = databaseSyncService.getMysqlInfoByNamespace(namespace);
            String destIp = map.get("ip");
            String destPort = map.get("port");
            log.info("获取到{}环境的Mysql地址为：{}", namespace, destIp + ":" + destPort);
            if (tableName.equalsIgnoreCase("all") || tableName.equals("")) {
                log.info("开始同步{}库下所有的表", dbName);
                databaseSyncService.getDbInfoFromSource(ip, port, username, password, dbName);
                databaseSyncService.syncDbToDest(destIp, destPort, "qa", "qatest", dbName);
            } else {
                log.info("开始同步{}库下{}表", dbName, tableName);
                databaseSyncService.getSingleTableFromSource(ip, port, username, password, dbName, tableName);
                databaseSyncService.syncSingleTableToDest(destIp, destPort, "qa", "qatest", dbName, tableName);
            }
            long endTime = System.currentTimeMillis();
            long elapsedTime = (endTime - startTime) / 1000;
            return JsonResult.buildSuccessResult(elapsedTime + "s");
        } catch (Exception e) {
            e.printStackTrace();
            return JsonResult.buildErrorStateResult("同步失败！", false);
        }
    }

    /**
     * 获取数据库列表
     * @return
     */
    @GetMapping("/dbs")
    public JsonResult getDatabaseList() {
        return JsonResult.buildSuccessResult(databaseSyncService.getDatabaseList(ip, port, username, password));
    }


    /**
     * 获取某个库下的表列表
     * @param dbName 数据库名
     * @return
     */
    @GetMapping("/tables")
    public JsonResult getTableList(@RequestParam String dbName) {
        List<Object> tableList = databaseSyncService.getTableListByDb(ip, port, username, password, dbName);
        tableList.add(0, "all");
        return JsonResult.buildSuccessResult(tableList);
    }
}
