package cn.qg.holmes.task.jira;

import cn.qg.holmes.service.jira.JiraIssueService;
import cn.qg.holmes.utils.DingdingUtils;
import com.atlassian.jira.rest.client.api.domain.Issue;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * Jira BUG通知到钉钉定时任务类
 */
@Component
@Slf4j
public class JiraToDingding {

    @Autowired
    JiraIssueService jiraIssueService;

    @Value("${sjgd.ding.url}")
    private String sjgdDingUrl;

    /**
     * 数据工单bug统计
     * @throws Exception
     */
    @Scheduled(cron = "0 0 19 * * ?")
    public void SJGDJiraIssueStatisticsTimedJob() throws Exception {
        Iterable<Issue> issues = jiraIssueService.getUnsolvedIssueListByProject("SJGD");
        String markdownMsg = DingdingUtils.buildMarkdownMsgForUnsolvedIssueList(issues);
        DingdingUtils.sendToDingding(markdownMsg, sjgdDingUrl);
    }
}
