package cn.qg.holmes.service.auto.impl;

import cn.qg.holmes.entity.auto.TestcaseReport;
import cn.qg.holmes.mapper.auto.TestcaseReportMapper;
import cn.qg.holmes.service.auto.TestcaseReportService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service
public class TestcaseReportServiceImpl extends ServiceImpl<TestcaseReportMapper, TestcaseReport> implements TestcaseReportService {

    @Autowired
    TestcaseReportMapper testcaseReportMapper;

    @Override
    public Map<String, Object> getTestcaseReportByNamespace(String namespace, Integer projectId, Integer pageNum, Integer pageSize) {
        QueryWrapper<TestcaseReport> testcaseReportQueryWrapper = new QueryWrapper<>();
        if (namespace != null && !namespace.isEmpty()) {
            testcaseReportQueryWrapper.eq("namespace", namespace);
        }
        if (projectId != null) {
            testcaseReportQueryWrapper.eq("project_id", projectId);
        }
        testcaseReportQueryWrapper.orderByDesc("id");

        Page<TestcaseReport> page = new Page<>(pageNum, pageSize);
        IPage<TestcaseReport> iPage = testcaseReportMapper.selectPage(page, testcaseReportQueryWrapper);

        Map<String, Object> map = new HashMap<>();
        map.put("total", iPage.getTotal());
        map.put("list", iPage.getRecords());
        return map;
    }

    @Override
    public IPage<Map<String, Object>> getTestcaseReportGroupByBatch(String namespace, Integer moduleId, Integer pageNum, Integer pageSize) {
        IPage<Map<String, Object>> page = new Page<>(pageNum, pageSize);
        return testcaseReportMapper.getTestcaseReportGroupByBatch(namespace, moduleId, page);
    }
}
