package cn.qg.holmes.controller.jira;

import cn.qg.holmes.service.jira.JiraIssueService;
import cn.qg.holmes.utils.DingdingUtils;
import com.atlassian.jira.rest.client.api.domain.Issue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@RequestMapping("/jira")
public class JiraController {

    @Autowired
    JiraIssueService jiraIssueService;

    @GetMapping("/report/project")
    public void sendReportToDingdingGroup(String project, String webhook) throws Exception {
        Iterable<Issue> issues = jiraIssueService.getUnsolvedIssueListByProject(project);
        String markdownMsg = DingdingUtils.buildMarkdownMsgForUnsolvedIssueList(issues);
        DingdingUtils.sendToDingding(markdownMsg, webhook);
    }
}
