package cn.qg.holmes.controller.auto;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.auto.Interface;
import cn.qg.holmes.service.auto.AutoModuleService;
import cn.qg.holmes.service.auto.InterfaceService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 接口相关controller
 * @author libo
 */
@CrossOrigin
@RestController
@RequestMapping("/auto/interface")
public class InterfaceController {

    @Autowired
    InterfaceService interfaceService;

    @Autowired
    AutoModuleService autoModuleService;

    /**
     * 获取接口列表
     * @param moduleId 非必传
     * @param pageNum 第几页
     * @param pageSize 每页数量
     * @return
     */
    @GetMapping("/list")
    public JsonResult getInterfaceList(Integer moduleId,
                                       @RequestParam(defaultValue = "1") Integer pageNum,
                                       @RequestParam(defaultValue = "10") Integer pageSize) {
        IPage<Interface> interfaceIPage = new Page<>(pageNum, pageSize);
        IPage<Interface> interfaceIPageEntity;
        if (moduleId != null) {
            QueryWrapper<Interface> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("module_id", moduleId);
            interfaceIPageEntity = interfaceService.page(interfaceIPage, queryWrapper);
        } else {
            interfaceIPageEntity = interfaceService.page(interfaceIPage);
        }
        Map<String, Object> map = new HashMap<>();
        List<Interface> interfaceList = interfaceIPageEntity.getRecords();
        for (Interface anInterface: interfaceList) {
            anInterface.setModuleName(autoModuleService.getById(anInterface.getModuleId()).getName());
        }
        map.put("total", interfaceIPageEntity.getTotal());
        map.put("list", interfaceList);
        return JsonResult.buildSuccessResult(map);
    }

    /**
     * 新增接口
     * @param interfaceEntity 接口类实体
     * @return
     */
    @PostMapping("/add")
    public JsonResult addInterface(@RequestBody Interface interfaceEntity) {
        QueryWrapper<Interface> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("module_id", interfaceEntity.getModuleId());
        queryWrapper.eq("url", interfaceEntity.getUrl());
        if (autoModuleService.getById(interfaceEntity.getModuleId()) == null) {
            return JsonResult.buildErrorStateResult("模块不存在！", false);
        }
        if (interfaceService.getOne(queryWrapper) != null) {
            return JsonResult.buildErrorStateResult("接口已存在！", false);
        } else {
            return JsonResult.buildSuccessResult(interfaceService.save(interfaceEntity));
        }
    }

    /**
     * 编辑接口
     * @param interfaceEntity 接口实体类
     * @return
     */
    @PostMapping("/modify")
    public JsonResult modifyInterface(@RequestBody Interface interfaceEntity) {
        if (interfaceService.getById(interfaceEntity.getId()) == null) {
            return JsonResult.buildErrorStateResult("接口不存在！", false);
        }
        return JsonResult.buildSuccessResult(interfaceService.updateById(interfaceEntity));
    }

    /**
     * 删除接口
     * @param interfaceId 接口id
     * @return
     */
    @GetMapping("/delete")
    public JsonResult deleteInterface(@RequestParam Integer interfaceId) {
        if (interfaceService.getById(interfaceId) == null) {
            return JsonResult.buildErrorStateResult("接口不存在！", false);
        }
        return JsonResult.buildSuccessResult(interfaceService.removeById(interfaceId));
    }
}
