package cn.qg.holmes.controller.monitor;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.monitor.MonitorDataSource;
import cn.qg.holmes.service.monitor.MonitorDataSourceService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

/**
 * 监控数据源相关接口
 */
@CrossOrigin
@RestController
@RequestMapping("/monitor/ds")
public class MonitorDataSourceController {

    @Autowired
    MonitorDataSourceService monitorDataSourceService;

    /**
     * 获取监控数据源列表，带分页和筛选
     * @param pageNum
     * @param pageSize
     * @param dsName
     * @return
     */
    @GetMapping("/listWithPaging")
    public JsonResult getMonitorDataSourceListWithPaging(@RequestParam(defaultValue = "1") Integer pageNum,
                                               @RequestParam(defaultValue = "10") Integer pageSize,
                                               String dsName) {
        IPage<MonitorDataSource> IPageParam = new Page<>(pageNum, pageSize);
        QueryWrapper<MonitorDataSource> queryWrapper = new QueryWrapper<>();
        if (!StringUtils.isEmpty(dsName)) {
            queryWrapper.eq("name", dsName);
        }
        IPage<MonitorDataSource> IPageResult = monitorDataSourceService.page(IPageParam);
        Map<String, Object> dsResult = new HashMap<>();
        dsResult.put("total", IPageResult.getTotal());
        dsResult.put("list", IPageResult.getRecords());
        return JsonResult.buildSuccessResult(dsResult);
    }

    /**
     * 获取监控数据源接口，不带分页和筛选
     * @return
     */
    @GetMapping("/list")
    public JsonResult getMonitorDataSourceList() {
        return JsonResult.buildSuccessResult(monitorDataSourceService.list());
    }

    /**
     * 添加监控数据源
     * @param monitorDataSource
     * @return
     */
    @PostMapping("/add")
    public JsonResult addMonitorDataSource(@RequestBody MonitorDataSource monitorDataSource) {
        return JsonResult.buildSuccessResult(monitorDataSourceService.saveOrUpdate(monitorDataSource));
    }

    /**
     * 更新监控数据源
     * @param monitorDataSource
     * @return
     */
    @PostMapping("/update")
    public JsonResult updateMonitorDataSource(@RequestBody MonitorDataSource monitorDataSource) {
        Integer dsId = monitorDataSource.getId();
        if (dsId == null) {
            return JsonResult.buildErrorStateResult("数据源不存在！", null);
        }
        if (monitorDataSourceService.getById(dsId) == null) {
            return JsonResult.buildErrorStateResult("数据源不存在", null);
        }
        return JsonResult.buildSuccessResult(monitorDataSourceService.saveOrUpdate(monitorDataSource));
    }

    /**
     * 删除监控数据源
     * @param monitorDataSource
     * @return
     */
    @PostMapping("/delete")
    public JsonResult deleteMonitorDataSource(@RequestBody MonitorDataSource monitorDataSource) {
        Integer dsId = monitorDataSource.getId();
        if (dsId == null) {
            return JsonResult.buildErrorStateResult("数据源不存在！", null);
        }
        if (monitorDataSourceService.getById(dsId) == null) {
            return JsonResult.buildErrorStateResult("数据源不存在", null);
        }
        return JsonResult.buildSuccessResult(monitorDataSourceService.getById(dsId));
    }
}
