package cn.qg.holmes.controller.auto;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.auto.Testcase;
import cn.qg.holmes.service.auto.TestcaseService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

/**
 * 用例相关接口
 * @author libo
 */
@CrossOrigin
@RestController
@RequestMapping("/auto/testcase")
public class TestcaseController {

    @Autowired
    TestcaseService testcaseService;

    /**
     * 获取单接口用例列表
     * @param moduleId 模块id
     * @param pageNum 第几页
     * @param pageSize 每页数量
     * @return
     */
    @GetMapping("/list")
    public JsonResult getTestcaseList(Integer moduleId,
                                      String testcaseName,
                                      @RequestParam(defaultValue = "1") Integer pageNum,
                                      @RequestParam(defaultValue = "10") Integer pageSize) {
        IPage<Testcase> testcaseIPageEntity = testcaseService.getTestcaseList(moduleId, testcaseName, pageNum, pageSize);
        Map<String, Object> map = new HashMap<>();
        map.put("total", testcaseIPageEntity.getTotal());
        map.put("list", testcaseIPageEntity.getRecords());
        return JsonResult.buildSuccessResult(map);
    }

    /**
     * 新增单接口用例
     * @param testcase
     * @return
     */
    @PostMapping("/add")
    public JsonResult addTestcase(@RequestBody Testcase testcase) {
        if (testcase.getName() == null || testcase.getInterfaceId() == null || testcase.getModuleId() == null) {
            return JsonResult.buildErrorStateResult("用例名称、接口、所属模块不能为空！", false);
        } else {
            return JsonResult.buildSuccessResult(testcaseService.save(testcase));
        }
    }

    /**
     * 编辑单接口用例
     * @param testcase 单接口用例实体
     * @return
     */
    @PostMapping("/modify")
    public JsonResult modifyTestcase(@RequestBody Testcase testcase) {
        if (testcase.getId() == null) {
            return JsonResult.buildErrorStateResult("用例id不能为空！", false);
        } else {
            return JsonResult.buildSuccessResult(testcaseService.updateById(testcase));
        }
    }

    /**
     * 删除测试用例
     * @param testcaseId 用例id
     * @return
     */
    @GetMapping("/delete")
    public JsonResult deleteTestcase(@RequestParam Integer testcaseId) {
        if (testcaseService.getById(testcaseId) == null) {
            return JsonResult.buildErrorStateResult("用例不存在！", false);
        } else {
            return JsonResult.buildSuccessResult(testcaseService.removeById(testcaseId));
        }
    }

}
