package cn.qg.holmes.controller.auto;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.auto.AutoProject;
import cn.qg.holmes.service.auto.AutoProjectService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

/**
 * 接口自动化项目相关controller
 * @author libo
 */
@CrossOrigin
@RestController
@RequestMapping("/auto/project")
public class AutoProjectController {

    @Autowired
    AutoProjectService autoProjectService;

    /**
     * 获取项目列表
     * @param pageNum 第几页
     * @param pageSize 每页数量
     * @return
     */
    @GetMapping("/list")
    public JsonResult getAutoProjectList(@RequestParam Integer pageNum, @RequestParam Integer pageSize) {
        IPage<AutoProject> projectIPage = new Page<>(pageNum, pageSize);
        IPage<AutoProject> projectPageEntity = autoProjectService.page(projectIPage);
        Map<String, Object> map = new HashMap<>();
        map.put("list", projectPageEntity.getRecords());
        map.put("total", projectPageEntity.getTotal());
        return JsonResult.buildSuccessResult(map);
    }

    /**
     * 新增项目
     * @param autoProject 项目实体
     * @return
     */
    @PostMapping("/add")
    public JsonResult autoProjectAdd(@RequestBody AutoProject autoProject) {
        // 判断项目是否已存在
        QueryWrapper<AutoProject> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("name", autoProject.getName());
        if (autoProjectService.getOne(queryWrapper) != null) {
            return JsonResult.buildErrorStateResult("该名称项目已存在!", false);
        } else {
            return JsonResult.buildSuccessResult(autoProjectService.save(autoProject));
        }
    }

    /**
     * 修改项目
     * @param autoProject 项目实体
     * @return
     */
    @PostMapping("/modify")
    public JsonResult autoProjectModify(@RequestBody AutoProject autoProject) {
        if (autoProjectService.getById(autoProject.getId()) == null) {
            return JsonResult.buildErrorStateResult("项目不存在", false);
        } else {
            return JsonResult.buildSuccessResult(autoProjectService.updateById(autoProject));
        }
    }

    /**
     * 删除项目
     * @param projectId 项目id
     */
    @GetMapping("/delete")
    public JsonResult autoProjectDelete(@RequestParam Integer projectId) {
        if (autoProjectService.getById(projectId) == null) {
            return JsonResult.buildErrorStateResult("该项目不存在！", false);
        } else {
            return JsonResult.buildSuccessResult(autoProjectService.removeById(projectId));
        }
    }
}
