package cn.qg.holmes.interceptor;

import cn.qg.holmes.entity.mock.Mock;
import cn.qg.holmes.mapper.mock.MockMapper;
import cn.qg.holmes.utils.HttpClientUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 风控相关接口拦截器
 * @author libo
 */
@Slf4j
public class RuleEngineInterceptor implements HandlerInterceptor {

    @Autowired
    MockMapper mockMapper;

    @Value("${early.settle.channel}")
    private String earlySettleChannel;

    public Map<String, Object> convertParameterMap(Map<String, String[]> parameterMap) {
        Map<String, Object> map = new HashMap<>();
        for (Map.Entry<String, String[]> entry: parameterMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue()[0];
            map.put(key, value);
        }
        return map;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String uri = request.getRequestURI();
        Map<String, String[]> parameterMap = request.getParameterMap();
        Map<String, Object> requestMap = convertParameterMap(parameterMap);
        QueryWrapper<Mock> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("url", uri);
        Mock mock = mockMapper.selectOne(queryWrapper);
        String mockData = null;
        if (mock.getFlag() == 0) {
            mockData = mock.getFail();
        }
        if (mock.getFlag() == 1) {
            mockData = mock.getSuccess();
        }
        if (uri.equals("/rule_engine/middle_office/audit")) {
            Map<String, Object> auditMap = JSON.parseObject(mockData, Map.class);
            Map<String, Object> responseMap = handleRiskAudit(requestMap, auditMap);
            InterceptorUtils.constructResponse(response, JSON.toJSONString(responseMap), "application/json; charset=utf-8");
            return false;
        }
        InterceptorUtils.constructResponse(response, mockData, "application/json; charset=utf-8");
        return true;
    }

    /**
     * 处理风控审核参数
     * @param requestMap HttpServletRequest请求参数Map
     * @return
     */
    public Map<String, Object> handleRiskAudit(Map<String, Object> requestMap, Map<String, Object> auditData) {
        Map<String, Object> bodyMap = new HashMap<>();
        Map<String, Object> resultMap = new HashMap<>();
        String bizType = requestMap.get("bizType").toString();
        String bizChannel = requestMap.get("bizChannel").toString();
        String uuid = requestMap.get("uuid").toString();
        String bizNo = requestMap.get("bizNo").toString();
        String sceneId = requestMap.get("sceneId").toString();
        resultMap.put("code", 0);
        resultMap.put("msg", "success");
        bodyMap.put("msg", "success");
        bodyMap.put("fundRate", null);
        bodyMap.put("secondaryValidation", "-1");
        bodyMap.put("amountRate", null);
        bodyMap.put("isWhiteBlackListHit", null);
        bodyMap.put("openingValidity", "15");
        bodyMap.put("creditLevel", null);
        bodyMap.put("isFuseModuleHit", null);
        bodyMap.put("callbackUrl", null);
        bodyMap.put("amountTermLimits", null);
        bodyMap.put("bizType", bizType);
        bodyMap.put("bizChannel", bizChannel);
        bodyMap.put("uuid", uuid);
        bodyMap.put("bizNo", bizNo);
        bodyMap.put("sceneId", sceneId);
        bodyMap.put("amount", null);
        bodyMap.put("xycreditScore", null);
        bodyMap.put("exportVccTag", null);
        bodyMap.put("term", null);
        bodyMap.put("validity", "30");
        bodyMap.put("deadLine", "4102415999000");
        bodyMap.put("financeProducts", null);
        bodyMap.put("otherInformation", null);
        bodyMap.put("extData", null);
        bodyMap.put("success", true);
        bodyMap.put("refuseReason", null);
        bodyMap.put("allowInstalment", null);
        bodyMap.put("allowInstalmentTerms", null);
        bodyMap.put("quotaPaymentAmount", null);
        bodyMap.put("auditResult", true);
        // 授信额度审核
        if (sceneId.equals("0")) {
            // vcc
            String callbackUrl = requestMap.get("callbackUrl").toString();
            if (callbackUrl.contains("talos")) {
                vccRiskAuthAmountCompletion(callbackUrl, bizChannel, uuid, bizNo, auditData.get("vccAuditAmount").toString(), auditData.get("vccAuditResult").toString());
            }
            // 一单一审现金贷
            if (bizType.equals("0")) {
            }
        }
        // KA准入审核, sceneId=2
        if (sceneId.equals("2")) {
            bodyMap.put("auditResult", auditData.get("KaAuditResult"));
        }
        // vcc账户冻结审核
        if (sceneId.equals("8")) {
        }
        // vcc账户解冻审核
        if (sceneId.equals("9")) {

        }
        // vcc账单分期审核, sceneId=11
        if (bizType.equals("8") && sceneId.equals("11")) {
            bodyMap.put("allowInstalment", "1");
            bodyMap.put("allowInstalmentTerms", "3,6,9,12");
        }
        // vcc支付限额审核, sceneId=12
        if (bizType.equals("8") && sceneId.equals("12")) {
            bodyMap.put("auditResult", auditData.get("vccQuotaPayAuditResult")); // true-允许使用额度支付, false-不允许使用额度支付
            bodyMap.put("quotaPaymentAmount", auditData.get("vccQuotaPaymentAmount").toString()); // quotaPaymentAmount
        }
        // 提前结清审核,如果渠道不在apollo配置里，则审核拒绝
        if (sceneId.equals("14")) {
            String[] earlySettleChannelArray = earlySettleChannel.split(",");
            if (!Arrays.asList(earlySettleChannelArray).contains(bizChannel)) {
                bodyMap.put("auditResult", false);
            }
        }
        resultMap.put("body", bodyMap);
        return resultMap;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler,
                           @Nullable ModelAndView modelAndView) throws Exception {
        log.info("本次请求返回响应：{}", response);
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler,
                                @Nullable Exception ex) throws Exception {
    }

    /**
     * vcc风控授信回调
     * @param callbackUrl 回调url
     * @param bizChannel 渠道号
     * @param uuid uuid
     * @param riskNo 授信单号
     * @param amount 授信金额
     * @param auditResult 授信结果，true/false
     */
    public static void vccRiskAuthAmountCompletion(String callbackUrl,String bizChannel, String uuid, String riskNo, String amount, String auditResult) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.DAY_OF_YEAR, calendar.get(Calendar.DAY_OF_YEAR) + 15);
        Long openingDeadLine = calendar.getTimeInMillis();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.add(Calendar.YEAR, 1);
        Long deadLine = calendar2.getTimeInMillis();
        Map<String, String> params = new HashMap<>();
        params.put("amount", amount);
        params.put("auditResult", auditResult);
        params.put("bizChannel", bizChannel);
        params.put("bizNo", riskNo);
        params.put("code", "0");
        params.put("deadLine", deadLine.toString());
        params.put("openingDeadLine", String.valueOf(openingDeadLine)); // 开户失败有效期
        params.put("success", "true");
        params.put("uuid", uuid);
        params.put("sceneId", "0");
        params.put("allowInstalment", "1"); // 1-允许分期，0-不允许分期
        params.put("allowInstalmentTerms", "3,6,9,12"); // 允许分期的期数
        Map<String, String> headers = new HashMap<>();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        String result = HttpClientUtils.doPost(callbackUrl, headers, params);
        log.info("vcc风控授信回调参数：{}", params);
        log.info("vcc风控授信回调结果：{}", result);
    }

    public static void quotaAuthAmountAuditNotify(String callbackUrl, String uuid, String bizChannel, String fundId, String bizNo, String bizType, String creditAmount, String term, String auditResult) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.DAY_OF_YEAR, calendar.get(Calendar.DAY_OF_YEAR) + 30);
        Long deadLine = calendar.getTimeInMillis();
        Map<String, String> headers = new HashMap<>();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        Map<String, String> params = new HashMap<>();
        params.put("code", "0");
        params.put("msg", "success");
        params.put("bizChannel", bizChannel);  // 渠道号
        params.put("uuid", uuid);
        params.put("bizNo", bizNo);
        params.put("bizType", bizType);  // 业务类型： 0-现金分期一单一审，……
        params.put("auditResult", auditResult);
        params.put("amount", creditAmount);
        params.put("deadLine", String.valueOf(deadLine));
        params.put("extData", "");
        params.put("otherInformation", "");
        JSONArray financeProducts = createFinanceProducts(fundId, term);
        params.put("financeProducts", JSONArray.toJSONString(financeProducts));
        HttpClientUtils.doPost(callbackUrl, headers, params);
        log.info("现金分期风控授信回调：{}", params);
    }

    public static JSONArray createFinanceProducts(String fundId, String term) {
        JSONArray financeProducts = new JSONArray();
        JSONObject financeProductsObject = new JSONObject();
        JSONArray terms = new JSONArray();
        financeProductsObject.put("max", 10000);
        financeProductsObject.put("min", 10000);
        JSONObject firstTerm = new JSONObject();
        firstTerm.put("term", term);
        JSONArray fundInfoList = new JSONArray();
        JSONObject fundInfoObject = new JSONObject();
        fundInfoObject.put("fundId", fundId);
        fundInfoObject.put("rate", 0);
        fundInfoObject.put("rateType", 1);
        fundInfoObject.put("priority", 1);
        fundInfoObject.put("feeType", 1);
        // 如果是云南信托，需要该参数
        if (fundId.equals("1040")) {
            fundInfoObject.put("fundProductId", 1061);
        }
        // 平顶山银行
        if (fundId.equals("1030")) {
            fundInfoObject.put("fundProductId", 1060);
        }
        fundInfoList.add(fundInfoObject);
        firstTerm.put("fundInfo", fundInfoList);
        terms.add(firstTerm);
        financeProductsObject.put("terms", terms);
        financeProducts.add(financeProductsObject);
        return financeProducts;
    }
}
