package cn.qg.holmes.controller.jira;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.jira.DingRobot;
import cn.qg.holmes.service.jira.DingRobotService;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.util.HashMap;
import java.util.Map;

@Slf4j
@RestController
@RequestMapping("/jira")
public class JiraWebhookController {

    @Autowired
    DingRobotService dingRobotService;

    /**
     * jira webhook
     * @param request
     */
    @PostMapping("/webhook")
    public void jiraWebhook(HttpServletRequest request) {
        try {
            BufferedReader br = request.getReader();
            StringBuilder jiraData = new StringBuilder();
            String str = "";
            while((str = br.readLine()) != null){
                jiraData.append(str);
            }
            br.close();
            dingRobotService.sendMsgToDing(String.valueOf(jiraData));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 项目机器人列表
     * @param pageNum 第几页
     * @param pageSize 每页多少个
     * @return
     */
    @GetMapping("/list/robot")
    public JsonResult getProjectRobotList(Integer pageNum, Integer pageSize) {
        IPage<DingRobot> page = new Page<>(pageNum, pageSize);
        IPage<DingRobot> projectRobotIPage = dingRobotService.page(page);
        Map<String, Object> map = new HashMap<>();
        map.put("total", projectRobotIPage.getTotal());
        map.put("list", projectRobotIPage.getRecords());
        return JsonResult.buildSuccessResult(map);
    }

    /**
     * 新增项目机器人
     * @param dingRobot 项目机器人实体
     * @return
     */
    @PostMapping("/add/robot")
    public JsonResult addProjectRobot(@RequestBody DingRobot dingRobot) {
        if (dingRobot.getProjectName() == null) {
            return JsonResult.buildErrorStateResult("项目名称不能为空！", false);
        }
        if (dingRobot.getDingUrl() == null) {
            return JsonResult.buildErrorStateResult("钉钉url不能为空！", false);
        }
        return JsonResult.buildSuccessResult(dingRobotService.save(dingRobot));
    }

    /**
     * 修改项目机器人
     * @param dingRobot 项目机器人实体
     * @return
     */
    @PostMapping("/modify/robot")
    public JsonResult editProjectRobot(@RequestBody DingRobot dingRobot) {
        if (dingRobot.getId() == null) {
            return JsonResult.buildErrorStateResult("id不能为空！", false);
        }
        if (dingRobot.getProjectName() == null) {
            return JsonResult.buildErrorStateResult("项目名称不能为空！", false);
        }
        if (dingRobot.getDingUrl() == null) {
            return JsonResult.buildErrorStateResult("钉钉url不能为空！", false);
        }
        return JsonResult.buildSuccessResult(dingRobotService.save(dingRobot));
    }

    /**
     * 删除项目机器人
     * @param projectRobotId 项目机器人实体id
     * @return
     */
    @PostMapping("/delete/robot")
    public JsonResult deleteProjectRobot(Integer projectRobotId) {
        if (dingRobotService.getById(projectRobotId) == null) {
            return JsonResult.buildErrorStateResult("项目机器人不存在！", false);
        }
        return JsonResult.buildSuccessResult(dingRobotService.removeById(projectRobotId));
    }
}
