package cn.qg.holmes.utils;

import cn.qg.holmes.entity.k8s.DockerProject;
import cn.qg.holmes.entity.k8s.ServiceCreateVo;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class TkeUtils {

    /**
     * 替换业务yaml文件
     * @param sourceString
     * @param serviceCreateVo
     * @param dockerProject
     * @return
     */
    public static String replaceBusinessYaml(String sourceString, ServiceCreateVo serviceCreateVo, DockerProject dockerProject) {
        if (!Objects.isNull(serviceCreateVo)) {
            sourceString = sourceString.replaceAll("\\{\\{serviceName}}", serviceCreateVo.getServiceName());
            sourceString = sourceString.replaceAll("\\{\\{namespace}}", serviceCreateVo.getNamespace());
            sourceString = sourceString.replaceAll("\\{\\{mock}}", String.valueOf(serviceCreateVo.getMock()));
            sourceString = sourceString.replaceAll("\\{\\{debug}}", String.valueOf(serviceCreateVo.getDebug()));
            sourceString = sourceString.replaceAll("\\{\\{label}}", serviceCreateVo.getLabel());
            sourceString = sourceString.replaceAll("\\{\\{image}}", serviceCreateVo.getImage());
            sourceString = sourceString.replaceAll("\\{\\{domain}}", serviceCreateVo.getDomain());
            sourceString = sourceString.replaceAll("\\{\\{type}}", serviceCreateVo.getType());
        }

        if (!Objects.isNull(dockerProject)) {
            sourceString = sourceString.replaceAll("\\{\\{resources.cpuRequest}}", dockerProject.getCpuRequest());
            sourceString = sourceString.replaceAll("\\{\\{resources.memRequest}}", dockerProject.getMemRequest());
            sourceString = sourceString.replaceAll("\\{\\{resources.cpuLimit}}", dockerProject.getCpuLimit());
            sourceString = sourceString.replaceAll("\\{\\{resources.memLimit}}", dockerProject.getMemLimit());
        }
        return sourceString;
    }

    /**
     * 替换基础服务yaml文件
     * @param sourceString
     * @param serviceCreateVo
     * @return
     */
    public static String replaceBasicYaml(String sourceString, ServiceCreateVo serviceCreateVo) {
        String namespace = serviceCreateVo.getNamespace();
        String image = serviceCreateVo.getImage();
        if (!StringUtils.isEmpty(namespace)) {
            sourceString = sourceString.replaceAll("\\{\\{namespace}}", namespace);
        }
        if (!StringUtils.isEmpty(image)) {
            sourceString = sourceString.replaceAll("\\{\\{image}}", image);
        }
        return sourceString;
    }

    /**
     * 字符串数组转Map
     * @param strArray 字符串数组
     * @return
     */
    public static Map<String, String> StringArrayToMap(String[] strArray) {
        // 字符串数组长度必须大于0且为偶数个
        if (strArray.length == 0 || strArray.length % 2 != 0) {
            return null;
        }
        Map<String, String> resultMap = new HashMap<>();
        for (int i=0; i < strArray.length; i=i+2) {
            resultMap.put(strArray[i], strArray[i+1]);
        }
        return resultMap;
    }
}
