package cn.qg.holmes.service.jira.impl;

import cn.qg.holmes.service.jira.JiraIssueService;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClientFactory;
import com.atlassian.jira.rest.client.api.domain.BasicProject;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.SearchResult;
import com.atlassian.jira.rest.client.internal.async.AsynchronousJiraRestClientFactory;
import io.atlassian.util.concurrent.Promise;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.springframework.stereotype.Service;

import java.net.URI;
import java.net.URISyntaxException;

@Service
public class JiraIssueServiceImpl implements JiraIssueService {

    public static String url = "http://jira2.quantgroup.cn/";
    public static String username = "test1";
    public static String password = "123456";
    public static JiraRestClient jiraRestClient = createJiraRestClient();

    public static JiraRestClient createJiraRestClient() {
        JiraRestClientFactory jiraRestClientFactory = new AsynchronousJiraRestClientFactory();
        JiraRestClient jiraRestClient = null;
        try {
            jiraRestClient = jiraRestClientFactory.createWithBasicHttpAuthentication(new URI(url), username, password);
        } catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return jiraRestClient;
    }

    /**
     * 根据项目关键字获取未解决BUG列表
     * @param project 项目关键字，如"YXM"
     * @return
     * @throws Exception
     */
    @Override
    public Iterable<Issue> getUnsolvedIssueListByProject(String project) throws Exception{
        Promise<SearchResult> resultPromise =  jiraRestClient.getSearchClient().searchJql("project = " + project + " AND resolution = Unresolved ORDER BY priority DESC");
        Iterable<Issue> issues = resultPromise.get().getIssues();
        return issues;
    }

    /**
     * 根据JQL获取BUG列表
     * @param JQL jira JQL
     * @return
     * @throws Exception
     */
    @Override
    public Iterable<Issue> getIssueListByJQL(String JQL) throws Exception {
        Promise<SearchResult> resultPromise =  jiraRestClient.getSearchClient().searchJql(JQL);
        Iterable<Issue> issues = resultPromise.get().getIssues();
        return issues;
    }

    /**
     * 获取Jira项目列表
     * @return
     * @throws Exception
     */
    @Override
    public Iterable<BasicProject> getJiraProjectList() throws Exception {
        Promise<Iterable<BasicProject>> allProjects = jiraRestClient.getProjectClient().getAllProjects();
        Iterable<BasicProject> basicProjects = allProjects.get();
        return basicProjects;
    }

    /**
     * 计算BUG修复时间
     * @param createDate BUG创建时间
     * @param updateDate BUG最近一次更新时间
     * @return
     */
    public Integer caculBugFixTime(DateTime createDate, DateTime updateDate) {
        int createHour = createDate.getHourOfDay();
        int updateHour = updateDate.getHourOfDay();
        if (createHour > 19) {
            createHour = 19;
        } else if (createHour < 10) {
            createHour = 10;
        }
        if (updateHour > 19) {
            updateHour = 19;
        }
        int hourDiff;
        if (updateHour > createHour) {
            hourDiff = updateHour - createHour -1;
        } else if (updateHour < createHour) {
            hourDiff = updateHour - createHour + 1;
        } else {
            hourDiff = updateHour - createHour;
        }
        int days = Days.daysBetween(createDate, updateDate).getDays();
        return (days+1) * 8 + hourDiff;
    }

}
