package cn.qg.holmes.interceptor;

import cn.qg.holmes.encrypt.EncryptConvertor;
import cn.qg.holmes.encrypt.EncryptFactory;
import cn.qg.holmes.entity.mock.Mock;
import cn.qg.holmes.entity.xincheng.RepaymentVo;
import cn.qg.holmes.mapper.mock.MockMapper;
import cn.qg.holmes.utils.HttpClientUtils;
import cn.qg.holmes.utils.RedisUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

import static cn.qg.holmes.interceptor.InterceptorUtils.*;

public class XinchengInterceptor implements HandlerInterceptor {

    @Autowired
    MockMapper mockMapper;

    @Autowired
    RedisUtils redisUtils;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception{
        String uri = request.getRequestURI();
//        Map<String, String[]> parameterMap = request.getParameterMap();
        Map<String, String> parameterMap = getParamsMap(request);
        QueryWrapper<Mock> mockQueryWrapper = new QueryWrapper<>();
        mockQueryWrapper.eq("url", uri);
        Mock mock = mockMapper.selectOne(mockQueryWrapper);
        EncryptConvertor encryptConvertor = EncryptFactory.produce("xincheng");
        String responseStr = null;
        if (mock.getFlag().equals(1)) {
            responseStr = mock.getSuccess();
        } else if (mock.getFlag().equals(0)) {
            responseStr = mock.getFail();
        }
        // 解析请求
        Map<String, Object> requestContentMap = new HashMap<>();
        if (parameterMap.size() != 0) {
            requestContentMap = JSON.parseObject(encryptConvertor.decrypt(parameterMap.get("content")), Map.class);
        }
        Map<String, Object> responseMap = JSON.parseObject(responseStr, Map.class);
        // 进件
        if (uri.equals("/webservice/api/lhp/v1/credit/creditApply")) {
            redisUtils.set(requestContentMap.get("orderNo").toString(), requestContentMap);
        }
        // 还款试算
        if (uri.equals("/webservice/api/lhp/v1/loan/calculator")) {
            String amount = requestContentMap.get("trialAmount").toString();
            String term = requestContentMap.get("terms").toString();
            Map<String, Object> caculatorMap = getLoanCaculatorResult(amount, term);
            constructResponse(response, encryptConvertor.encrypt(JSON.toJSONString(caculatorMap)), "application/json; charset=utf-8");
            return false;
        }
        // 还款计划
        if (uri.equals("/webservice/api/lhp/v1/loan/repay/plan")) {
            String orderNo =  requestContentMap.get("orderNo").toString();
            Map<String, Object> redisValue = JSONObject.parseObject(JSON.toJSONString(redisUtils.get(orderNo)), Map.class);
            Map<String, Object> loanInfo = JSONObject.parseObject(redisValue.get("loanInfo").toString(), Map.class);
            String amount = loanInfo.get("amount").toString();
            String term = loanInfo.get("term").toString();
            List<RepaymentVo> repaymentVoList = getRepaymentPlanList(orderNo, amount, term, new Date());
            Map<String, Object> repayPlanMap = new HashMap<>();
            repayPlanMap.put("data", repaymentVoList);
            repayPlanMap.put("msg", "OK");
            repayPlanMap.put("code", 0);
            constructResponse(response, encryptConvertor.encrypt(JSON.toJSONString(repayPlanMap)), "application/json; charset=utf-8");
            return false;
        }
        responseMap = disposeResponseMap(requestContentMap, responseMap);
        constructResponse(response, encryptConvertor.encrypt(JSON.toJSONString(responseMap)), "application/json; charset=utf-8");
        return false;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler,
                           @Nullable ModelAndView modelAndView) {
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler,
                                @Nullable Exception ex) {
    }

    public static Map<String, String> getParamsMap(HttpServletRequest request) throws Exception{
        BufferedReader br = request.getReader();
        String str = "";
        StringBuilder requestData = new StringBuilder();
        while((str = br.readLine()) != null){
            requestData.append(str);
        }
        br.close();
        Map<String, String> paramsMap = JSON.parseObject(requestData.toString(), Map.class);
        return paramsMap;
    }

    /**
     * 生成还款计划
     * @param orderNo
     * @param contractLoanAmount
     * @param contractTerm
     * @param createRepaymentAt
     * @return
     */
    public static List<RepaymentVo> getRepaymentPlanList(String orderNo, String contractLoanAmount, String contractTerm, Date createRepaymentAt) {
        List<RepaymentVo> repaymentVoList =  new ArrayList<>();
        SimpleDateFormat  simpleDateFormat  = new SimpleDateFormat("yyyy-MM-dd");
        String createDateStr = simpleDateFormat.format(createRepaymentAt);
        Map<String, String> params = new HashMap<>();
        params.put("fundCorpProductId", "100053");
        params.put("stage", "0");
        params.put("amount", contractLoanAmount);
        params.put("term", contractTerm);
        params.put("date", createDateStr);
        String response = HttpClientUtils.doPost("https://mo-trade-qa.liangkebang.net/middle_office/finance/build_repayment_plan", params);
        Map<String, String> caculMap = JSON.parseObject(response, Map.class);
        List<Map> repayList = JSONArray.parseArray(JSON.toJSONString(caculMap.get("data")), Map.class);
        for (Map map: repayList)  {
            RepaymentVo repaymentVo = new RepaymentVo();
            repaymentVo.setOrderNo(orderNo);
            repaymentVo.setTermNo((Integer) map.get("term"));
            Map<String, Object> subjectMap = JSON.parseObject(JSON.toJSONString(map.get("subject")), Map.class);
            repaymentVo.setRepayPrincipal((BigDecimal) subjectMap.get("principal"));
            repaymentVo.setRepayInterest((BigDecimal) subjectMap.get("interest"));
            repaymentVo.setServiceFee((BigDecimal) subjectMap.get("guarantee"));
        }
        return repaymentVoList;
    }

    // 生成还款试算
    public static Map<String, Object> getLoanCaculatorResult(String amount, String term) throws Exception {
        Map<String, Object> resultMap = new HashMap<>();
        SimpleDateFormat  simpleDateFormat  = new SimpleDateFormat("yyyy-MM-dd");
        String createDateStr = simpleDateFormat.format(new Date());
        Map<String, String> params = new HashMap<>();
        params.put("fundCorpProductId", "100053");
        params.put("stage", "0");
        params.put("amount", amount);
        params.put("term", term);
        params.put("date", createDateStr);
        String response = HttpClientUtils.doPost("https://mo-trade-qa.liangkebang.net/middle_office/finance/build_repayment_plan", params);
        Map<String, String> caculMap = JSON.parseObject(response, Map.class);
        List<Map> repayList = JSONArray.parseArray(JSON.toJSONString(caculMap.get("data")), Map.class);
        List<Map<String, Object>> caculList = new ArrayList<>();
        for (Map map: repayList)  {
            Map<String, Object> repay = new HashMap<>();
            repay.put("termNo", map.get("term"));
            Map<String, Object> subjectMap = JSON.parseObject(JSON.toJSONString(map.get("subject")), Map.class);
            repay.put("principal", subjectMap.get("principal"));
            repay.put("interest", subjectMap.get("interest"));
            repay.put("serviceFee", subjectMap.get("guarantee"));
            repay.put("totalAmount", subjectMap.get("requiredRepayment"));
            repay.put("otherFee", 0.00);
            repay.put("deadline", simpleDateFormat.parse(subjectMap.get("deadline").toString()).getTime()/1000);
            caculList.add(repay);
        }
        Integer interestAmount = 0;
        Integer serviceFeeAmount = 0;
        Integer principalAmount = 0;
        Integer totalRepayAmount = 0;
        Integer otherFeeAmount = 0;
        for (Map map2: caculList) {
            interestAmount += Integer.parseInt(map2.get("interest").toString());
            serviceFeeAmount += Integer.parseInt(map2.get("serviceFee").toString());
            principalAmount += Integer.parseInt(map2.get("principal").toString());
            totalRepayAmount += Integer.parseInt(map2.get("totalAmount").toString());
        }
        Map<String, Object> dataMap = new HashMap<>();
        dataMap.put("serviceFeeAmount", serviceFeeAmount);
        dataMap.put("interestAmount", interestAmount);
        dataMap.put("principalAmount", principalAmount);
        dataMap.put("totalRepayAmount", totalRepayAmount);
        dataMap.put("otherFeeAmount", otherFeeAmount);
        dataMap.put("plans", caculList);

        resultMap.put("msg", "OK");
        resultMap.put("code", 0);
        resultMap.put("data", dataMap);
        return resultMap;
    }

}
