package cn.qg.holmes.entity.mock.keystone.jdbuy;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 7.8 查询配送信息
 */
@Data
public class JdOrderTrackResponse extends JdBaseResponse{

    private static final String TIME_FORMAT_YYYYMMDDHHMMSS = "yyyy-MM-dd HH:mm:ss";

    private OrderTrackInfo result;

    @Data
    public static class OrderTrackInfo{

        private List<OrderTrack> orderTrack;

        private String jdOrderId;

        private List<WaybillCode> waybillCode;
    }


    @Data
    public static class OrderTrack{
        private String content;  //操作内容明细

        @JsonFormat(timezone = "GMT+8", pattern = TIME_FORMAT_YYYYMMDDHHMMSS)
        private Date msgTime;  //操作时间

        private String operator;  //操作员名称
    }

    @Data
    public static class WaybillCode{

        private Long orderId;  //订单号

        private Long parentId;  //父订单号

        private String carrier;  //承运商

        private String deliveryOrderId;  //运单号
    }
}
