package cn.qg.holmes.controller.mock.keystone;

import cn.qg.holmes.entity.mock.keystone.BizSku;
import cn.qg.holmes.entity.mock.keystone.SubmitOrderRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.RandomStringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@RestController
public class OrderController {

    /**
     * 商品税率
     */
    private final BigDecimal TAX = new BigDecimal("0.13");

    /**
     * SKU分配，随便MOCK一个
     */
    private final Integer SKU_CATEGORY = 15924;

    /**
     * 企业购提交订单接口
     * @param submitOrderRequest 请求参数
     * @return
     */
    @PostMapping("/api/order/submitOrder")
    public JSONObject qygSubmitOrder(SubmitOrderRequest submitOrderRequest) {
        log.info("收到企业购提交订单请求：{}", JSON.toJSONString(submitOrderRequest));
        JSONObject response = new JSONObject();
        List<SubmitOrderRequest.JdSkuPriceInfo> orderPriceSnaps = (List<SubmitOrderRequest.JdSkuPriceInfo>) JSONObject.parse(submitOrderRequest.getOrderPriceSnap());
        List<SubmitOrderRequest.JdSkuInfo> skuInfos = (List<SubmitOrderRequest.JdSkuInfo>) JSONObject.parse(submitOrderRequest.getSku());
        Map<String, BigDecimal> skuPriceMap = convertSkuPriceMap(orderPriceSnaps);
        // 计算订单总金额
        BigDecimal orderPrice = new BigDecimal(0);
        for (SubmitOrderRequest.JdSkuInfo jdSkuInfo: skuInfos) {
            BigDecimal skuNum = new BigDecimal(jdSkuInfo.getNum());
            String skuId = jdSkuInfo.getSkuId();
            BigDecimal price = skuPriceMap.get(skuId);
            orderPrice = orderPrice.add(price.multiply(skuNum));
        }
        response.put("success", true);
        response.put("resultCode", "0001");
        response.put("resultMessage", "下单成功");
        JSONObject result = new JSONObject();
        result.put("jdOrderId", RandomStringUtils.randomNumeric(12));
        result.put("freight", calculateFreight(orderPrice));
        result.put("orderPrice", orderPrice);
        BigDecimal orderNakedPrice = orderPrice.divide(TAX.add(new BigDecimal(1)), BigDecimal.ROUND_HALF_UP);
        result.put("orderNakedPrice", orderNakedPrice);
        List<BizSku> bizSkuList = new ArrayList<>();
        for (SubmitOrderRequest.JdSkuInfo sku: skuInfos) {
            BizSku bizSku = new BizSku();
            String skuId = sku.getSkuId();
            bizSku.setSkuId(Long.valueOf(skuId));
            bizSku.setNum(sku.getNum());
            bizSku.setCategory(SKU_CATEGORY);
            BigDecimal price = skuPriceMap.get(skuId);
            bizSku.setPrice(price);
            bizSku.setName("xxx商品");
            bizSku.setTax(TAX.multiply(new BigDecimal(102)));
            BigDecimal nakedPrice = price.divide(TAX.add(new BigDecimal(1)), BigDecimal.ROUND_HALF_UP);
            bizSku.setNakedPrice(nakedPrice);
            bizSku.setTaxPrice(price.subtract(nakedPrice));
            bizSku.setType(0);
            bizSku.setOid(0L);

            bizSkuList.add(bizSku);
        }
        result.put("sku", bizSkuList);
        result.put("orderTaxPrice", orderNakedPrice.multiply(TAX).setScale(2, BigDecimal.ROUND_HALF_UP));
        response.put("result", result);
        return response;
    }

    public Map<String, BigDecimal> convertSkuPriceMap(List<SubmitOrderRequest.JdSkuPriceInfo> orderPriceSnaps) {
        Map<String, BigDecimal> map = new HashMap<>();
        for (SubmitOrderRequest.JdSkuPriceInfo jdSkuPriceInfo: orderPriceSnaps) {
            map.put(jdSkuPriceInfo.getSkuId(), jdSkuPriceInfo.getPrice());
        }
        return map;
    }

    /**
     * 计算运费
     * @param totalPrice 总价格
     * @return
     */
    public BigDecimal calculateFreight(BigDecimal totalPrice) {
        if (totalPrice.compareTo(new BigDecimal("99")) >= 0) {
            return new BigDecimal("0");
        } else {
            return new BigDecimal("6");
        }
    }
}
