package cn.qg.holmes.entity.mock.keystone.jdbuy;

import lombok.Data;

/**
 * 查询运费请求
 */
@Data
public class JdFreightRequest {

    private String token;

    /**
     * 商品的sku集合 以json形式传递（最多支持50种商品）
     */
    private String sku;

    /**
     * 一级地址
     */
    private Long province;

    /**
     * 二级地址
     */
    private Long city;

    /**
     * 三级地址
     */
    private Long county;

    /**
     * 四级地址
     */
    private Long town = 0L;

    /**
     * 京东支付方式
     */
    private Long paymentType = 5L;

    @Data
    public static class JdOrderSkuInfo {

        private String skuId;

        private Integer num;
    }
}
