package cn.qg.holmes.controller.auth;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.auth.Permission;
import cn.qg.holmes.service.auth.PermissionService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

@CrossOrigin
@RestController
@RequestMapping("/permission")
public class PermissionController {

    @Autowired
    PermissionService permissionService;

    /**
     * 新增权限
     * @param permission 权限实体
     * @return
     */
    @PostMapping("/add")
    public JsonResult addPermission(@RequestBody Permission permission) {
        return JsonResult.buildSuccessResult(permissionService.save(permission));
    }

    /**
     * 编辑权限
     * @param permission 权限实体
     * @return
     */
    @PostMapping("/edit")
    public JsonResult editPermission(@RequestBody Permission permission) {
        return JsonResult.buildSuccessResult(permissionService.saveOrUpdate(permission));
    }

    /**
     * 删除权限
     * @param permissionId 权限id
     * @return
     */
    @GetMapping("/del")
    public JsonResult delPermission(@RequestParam Integer permissionId) {
        return JsonResult.buildSuccessResult(permissionService.removeById(permissionId));
    }

    /**
     * 获取权限列表
     * @return
     */
    @GetMapping("/list")
    public JsonResult getPermissionList() {
        return JsonResult.buildSuccessResult(permissionService.getPermissionList());
    }

    @GetMapping("/list/paging")
    public JsonResult getPermissionListByPage(@RequestParam Integer pageNum, @RequestParam Integer pageSize, String menuName) {
        IPage<Permission> iPage = new Page<>(pageNum, pageSize);
        QueryWrapper<Permission> permissionQueryWrapper = new QueryWrapper<>();
        if (!StringUtils.isEmpty(menuName)) {
            permissionQueryWrapper.like("menu_name", menuName);
        }
        IPage page = permissionService.page(iPage, permissionQueryWrapper);
        Map<String, Object> map = new HashMap<>();
        map.put("total", page.getTotal());
        map.put("list", page.getRecords());
        return JsonResult.buildSuccessResult(map);
    }
}
