package cn.qg.holmes.aspect;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.exception.TokenInvalidException;
import cn.qg.holmes.exception.UnauthorizedException;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 全局异常处理
 * @author libo
 */
@ControllerAdvice
@ResponseBody
public class ExceptionHandlerAdvice {

    /**
     * 权限不足
     */
    @ExceptionHandler(UnauthorizedException.class)
    public JsonResult handleException(UnauthorizedException e) {
        e.printStackTrace();
        return JsonResult.buildErrorStateResult("权限不足！", false);
    }

    /**
     * Token无效
     */
    @ExceptionHandler(TokenInvalidException.class)
    public JsonResult handleException(TokenInvalidException e) {
        e.printStackTrace();
        return JsonResult.buildErrorStateResult("登录已失效，请重新登录！", false);
    }

    /**
     * 参数验证失败
     */
    @ExceptionHandler(MethodArgumentNotValidException.class)
    public JsonResult handleException(MethodArgumentNotValidException e) {
        e.printStackTrace();
        ObjectError objectError = e.getBindingResult().getAllErrors().get(0);
        return JsonResult.buildErrorStateResult(objectError.getDefaultMessage(), false);
    }

    /**
     * 参数必须性处理
     */
    @ExceptionHandler(MissingServletRequestParameterException.class)
    public JsonResult handleException(MissingServletRequestParameterException e) {
        e.printStackTrace();
        return JsonResult.buildErrorStateResult(e.getMessage(), false);
    }

    /**
     * 其他所有异常
     */
    @ExceptionHandler(Exception.class)
    public JsonResult handleException(Exception e) {
        e.printStackTrace();
        return JsonResult.buildErrorStateResult("系统异常！", false);
    }
}
