package cn.qg.holmes.config;

import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;

@Slf4j
@Component
public class UserPhoneMap {

    public Map<String, String> USER_PHONE_MAP;

    private static String readJsonile(String file) {
        String str = "";
        try {
            ClassPathResource resource = new ClassPathResource(file);
            InputStream in = resource.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            StringBuffer stringBuffer = new StringBuffer();
            while ((str = br.readLine()) != null) {
                stringBuffer.append(str);
            }
            return stringBuffer.toString();
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @PostConstruct
    public void readUserPhoneMap() {
        log.info("开始读取USER_PHONE_MAP.");
        USER_PHONE_MAP = JSON.parseObject(readJsonile("user-phone.json"), Map.class);
        log.info("读取到USER_PHONE_MAP：{}", JSON.toJSONString(USER_PHONE_MAP));
    }
}
