package cn.qg.holmes.service.gitlab.impl;

import cn.qg.holmes.entity.gitlab.Pipeline;
import cn.qg.holmes.mapper.gitlab.PipelineMapper;
import cn.qg.holmes.service.gitlab.PipelineService;
import cn.qg.holmes.service.jira.DingRobotService;
import cn.qg.holmes.utils.DingdingUtils;
import cn.qg.holmes.utils.JenkinsService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jayway.jsonpath.JsonPath;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class PipelineServiceImpl extends ServiceImpl<PipelineMapper, Pipeline> implements PipelineService {

    @Autowired
    PipelineMapper pipelineMapper;

    @Autowired
    JenkinsService jenkinsService;

    @Autowired
    DingRobotService dingRobotService;
    /**
     * 构建pipeline
     * @param gitlabData gitlab发送过来的推送事件
     */
    @Override
    public void buildPipelineJob(String gitlabData) {
        String projectName = JsonPath.read(gitlabData, "$.project.name");
        String branch = JsonPath.read(gitlabData, "$.project.default_branch");
        String message = JsonPath.read(gitlabData, "$.commits[0].message");
        String author = JsonPath.read(gitlabData, "$.user_username");
        String commitDate = JsonPath.read(gitlabData, "$.commits[0].timestamp");
        QueryWrapper<Pipeline> pipelineQueryWrapper = new QueryWrapper<>();
        pipelineQueryWrapper.eq("service_name", projectName);
        pipelineQueryWrapper.eq("service_branch", branch);
        Pipeline pipeline = pipelineMapper.selectOne(pipelineQueryWrapper);
        if (pipeline != null) {
            if (pipeline.getEnable() == 1) {
                log.info("pipeline中找到对应项目，且项目是启动状态，开始构建：{}", pipeline.toString());
                jenkinsService.buildJenkinsJob(pipeline.getServiceType(), projectName, branch, pipeline.getNamespace());
                String markdown = DingdingUtils.buildPipelineMarkdownMsg(projectName, branch, author, message, commitDate, pipeline.getNamespace());
                DingdingUtils.sendToDingding(markdown, dingRobotService.getById(pipeline.getDingRobotId()).getDingUrl());
            } else {
                log.info("pipeline中找到项目，但是项目状态为不启用，因此不构建！");
            }
        } else {
            log.info("pipeline中未找到该项目相关信息，不触发自动构建！");
        }
    }
}
